"use strict";

var helpers = require("../../helpers/helpers");

exports["Atlantic/Canary"] = {

	"guess:by:offset" : helpers.makeTestGuess("Atlantic/Canary", { offset: true, expect: "Europe/London" }),

	"guess:by:abbr" : helpers.makeTestGuess("Atlantic/Canary", { abbr: true, expect: "Europe/Lisbon" }),

	"1922" : helpers.makeTestYear("Atlantic/Canary", [
		["1922-03-01T01:01:36+00:00", "00:01:36", "-01", 60]
	]),

	"1946" : helpers.makeTestYear("Atlantic/Canary", [
		["1946-09-30T01:59:59+00:00", "00:59:59", "-01", 60],
		["1946-09-30T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1980" : helpers.makeTestYear("Atlantic/Canary", [
		["1980-04-05T23:59:59+00:00", "23:59:59", "WET", 0],
		["1980-04-06T00:00:00+00:00", "01:00:00", "WEST", -60],
		["1980-09-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1980-09-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1981" : helpers.makeTestYear("Atlantic/Canary", [
		["1981-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["1981-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1981-09-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1981-09-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1982" : helpers.makeTestYear("Atlantic/Canary", [
		["1982-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["1982-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1982-09-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1982-09-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1983" : helpers.makeTestYear("Atlantic/Canary", [
		["1983-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["1983-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1983-09-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1983-09-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1984" : helpers.makeTestYear("Atlantic/Canary", [
		["1984-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["1984-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1984-09-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1984-09-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1985" : helpers.makeTestYear("Atlantic/Canary", [
		["1985-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["1985-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1985-09-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1985-09-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1986" : helpers.makeTestYear("Atlantic/Canary", [
		["1986-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["1986-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1986-09-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1986-09-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1987" : helpers.makeTestYear("Atlantic/Canary", [
		["1987-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["1987-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1987-09-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1987-09-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1988" : helpers.makeTestYear("Atlantic/Canary", [
		["1988-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["1988-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1988-09-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1988-09-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1989" : helpers.makeTestYear("Atlantic/Canary", [
		["1989-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["1989-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1989-09-24T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1989-09-24T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1990" : helpers.makeTestYear("Atlantic/Canary", [
		["1990-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["1990-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1990-09-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1990-09-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1991" : helpers.makeTestYear("Atlantic/Canary", [
		["1991-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["1991-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1991-09-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1991-09-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1992" : helpers.makeTestYear("Atlantic/Canary", [
		["1992-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["1992-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1992-09-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1992-09-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1993" : helpers.makeTestYear("Atlantic/Canary", [
		["1993-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["1993-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1993-09-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1993-09-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1994" : helpers.makeTestYear("Atlantic/Canary", [
		["1994-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["1994-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1994-09-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1994-09-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1995" : helpers.makeTestYear("Atlantic/Canary", [
		["1995-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["1995-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1995-09-24T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1995-09-24T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1996" : helpers.makeTestYear("Atlantic/Canary", [
		["1996-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["1996-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1996-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1996-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1997" : helpers.makeTestYear("Atlantic/Canary", [
		["1997-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["1997-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1997-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1997-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1998" : helpers.makeTestYear("Atlantic/Canary", [
		["1998-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["1998-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1998-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1998-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"1999" : helpers.makeTestYear("Atlantic/Canary", [
		["1999-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["1999-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["1999-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["1999-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2000" : helpers.makeTestYear("Atlantic/Canary", [
		["2000-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2000-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2000-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2000-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2001" : helpers.makeTestYear("Atlantic/Canary", [
		["2001-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2001-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2001-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2001-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2002" : helpers.makeTestYear("Atlantic/Canary", [
		["2002-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2002-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2002-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2002-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2003" : helpers.makeTestYear("Atlantic/Canary", [
		["2003-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2003-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2003-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2003-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2004" : helpers.makeTestYear("Atlantic/Canary", [
		["2004-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2004-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2004-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2004-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2005" : helpers.makeTestYear("Atlantic/Canary", [
		["2005-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2005-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2005-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2005-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2006" : helpers.makeTestYear("Atlantic/Canary", [
		["2006-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2006-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2006-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2006-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2007" : helpers.makeTestYear("Atlantic/Canary", [
		["2007-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2007-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2007-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2007-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2008" : helpers.makeTestYear("Atlantic/Canary", [
		["2008-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2008-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2008-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2008-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2009" : helpers.makeTestYear("Atlantic/Canary", [
		["2009-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2009-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2009-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2009-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2010" : helpers.makeTestYear("Atlantic/Canary", [
		["2010-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2010-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2010-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2010-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2011" : helpers.makeTestYear("Atlantic/Canary", [
		["2011-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2011-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2011-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2011-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2012" : helpers.makeTestYear("Atlantic/Canary", [
		["2012-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2012-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2012-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2012-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2013" : helpers.makeTestYear("Atlantic/Canary", [
		["2013-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2013-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2013-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2013-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2014" : helpers.makeTestYear("Atlantic/Canary", [
		["2014-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2014-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2014-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2014-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2015" : helpers.makeTestYear("Atlantic/Canary", [
		["2015-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2015-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2015-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2015-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2016" : helpers.makeTestYear("Atlantic/Canary", [
		["2016-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2016-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2016-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2016-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2017" : helpers.makeTestYear("Atlantic/Canary", [
		["2017-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2017-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2017-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2017-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2018" : helpers.makeTestYear("Atlantic/Canary", [
		["2018-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2018-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2018-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2018-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2019" : helpers.makeTestYear("Atlantic/Canary", [
		["2019-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2019-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2019-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2019-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2020" : helpers.makeTestYear("Atlantic/Canary", [
		["2020-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2020-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2020-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2020-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2021" : helpers.makeTestYear("Atlantic/Canary", [
		["2021-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2021-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2021-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2021-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2022" : helpers.makeTestYear("Atlantic/Canary", [
		["2022-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2022-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2022-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2022-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2023" : helpers.makeTestYear("Atlantic/Canary", [
		["2023-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2023-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2023-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2023-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2024" : helpers.makeTestYear("Atlantic/Canary", [
		["2024-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2024-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2024-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2024-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2025" : helpers.makeTestYear("Atlantic/Canary", [
		["2025-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2025-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2025-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2025-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2026" : helpers.makeTestYear("Atlantic/Canary", [
		["2026-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2026-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2026-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2026-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2027" : helpers.makeTestYear("Atlantic/Canary", [
		["2027-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2027-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2027-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2027-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2028" : helpers.makeTestYear("Atlantic/Canary", [
		["2028-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2028-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2028-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2028-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2029" : helpers.makeTestYear("Atlantic/Canary", [
		["2029-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2029-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2029-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2029-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2030" : helpers.makeTestYear("Atlantic/Canary", [
		["2030-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2030-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2030-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2030-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2031" : helpers.makeTestYear("Atlantic/Canary", [
		["2031-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2031-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2031-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2031-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2032" : helpers.makeTestYear("Atlantic/Canary", [
		["2032-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2032-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2032-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2032-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2033" : helpers.makeTestYear("Atlantic/Canary", [
		["2033-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2033-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2033-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2033-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2034" : helpers.makeTestYear("Atlantic/Canary", [
		["2034-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2034-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2034-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2034-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2035" : helpers.makeTestYear("Atlantic/Canary", [
		["2035-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2035-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2035-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2035-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2036" : helpers.makeTestYear("Atlantic/Canary", [
		["2036-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2036-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2036-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2036-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2037" : helpers.makeTestYear("Atlantic/Canary", [
		["2037-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2037-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2037-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2037-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2038" : helpers.makeTestYear("Atlantic/Canary", [
		["2038-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2038-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2038-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2038-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2039" : helpers.makeTestYear("Atlantic/Canary", [
		["2039-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2039-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2039-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2039-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2040" : helpers.makeTestYear("Atlantic/Canary", [
		["2040-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2040-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2040-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2040-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2041" : helpers.makeTestYear("Atlantic/Canary", [
		["2041-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2041-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2041-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2041-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2042" : helpers.makeTestYear("Atlantic/Canary", [
		["2042-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2042-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2042-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2042-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2043" : helpers.makeTestYear("Atlantic/Canary", [
		["2043-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2043-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2043-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2043-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2044" : helpers.makeTestYear("Atlantic/Canary", [
		["2044-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2044-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2044-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2044-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2045" : helpers.makeTestYear("Atlantic/Canary", [
		["2045-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2045-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2045-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2045-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2046" : helpers.makeTestYear("Atlantic/Canary", [
		["2046-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2046-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2046-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2046-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2047" : helpers.makeTestYear("Atlantic/Canary", [
		["2047-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2047-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2047-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2047-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2048" : helpers.makeTestYear("Atlantic/Canary", [
		["2048-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2048-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2048-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2048-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2049" : helpers.makeTestYear("Atlantic/Canary", [
		["2049-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2049-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2049-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2049-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2050" : helpers.makeTestYear("Atlantic/Canary", [
		["2050-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2050-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2050-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2050-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2051" : helpers.makeTestYear("Atlantic/Canary", [
		["2051-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2051-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2051-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2051-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2052" : helpers.makeTestYear("Atlantic/Canary", [
		["2052-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2052-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2052-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2052-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2053" : helpers.makeTestYear("Atlantic/Canary", [
		["2053-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2053-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2053-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2053-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2054" : helpers.makeTestYear("Atlantic/Canary", [
		["2054-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2054-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2054-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2054-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2055" : helpers.makeTestYear("Atlantic/Canary", [
		["2055-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2055-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2055-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2055-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2056" : helpers.makeTestYear("Atlantic/Canary", [
		["2056-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2056-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2056-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2056-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2057" : helpers.makeTestYear("Atlantic/Canary", [
		["2057-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2057-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2057-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2057-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2058" : helpers.makeTestYear("Atlantic/Canary", [
		["2058-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2058-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2058-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2058-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2059" : helpers.makeTestYear("Atlantic/Canary", [
		["2059-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2059-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2059-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2059-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2060" : helpers.makeTestYear("Atlantic/Canary", [
		["2060-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2060-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2060-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2060-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2061" : helpers.makeTestYear("Atlantic/Canary", [
		["2061-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2061-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2061-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2061-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2062" : helpers.makeTestYear("Atlantic/Canary", [
		["2062-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2062-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2062-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2062-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2063" : helpers.makeTestYear("Atlantic/Canary", [
		["2063-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2063-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2063-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2063-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2064" : helpers.makeTestYear("Atlantic/Canary", [
		["2064-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2064-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2064-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2064-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2065" : helpers.makeTestYear("Atlantic/Canary", [
		["2065-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2065-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2065-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2065-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2066" : helpers.makeTestYear("Atlantic/Canary", [
		["2066-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2066-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2066-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2066-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2067" : helpers.makeTestYear("Atlantic/Canary", [
		["2067-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2067-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2067-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2067-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2068" : helpers.makeTestYear("Atlantic/Canary", [
		["2068-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2068-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2068-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2068-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2069" : helpers.makeTestYear("Atlantic/Canary", [
		["2069-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2069-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2069-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2069-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2070" : helpers.makeTestYear("Atlantic/Canary", [
		["2070-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2070-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2070-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2070-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2071" : helpers.makeTestYear("Atlantic/Canary", [
		["2071-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2071-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2071-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2071-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2072" : helpers.makeTestYear("Atlantic/Canary", [
		["2072-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2072-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2072-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2072-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2073" : helpers.makeTestYear("Atlantic/Canary", [
		["2073-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2073-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2073-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2073-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2074" : helpers.makeTestYear("Atlantic/Canary", [
		["2074-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2074-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2074-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2074-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2075" : helpers.makeTestYear("Atlantic/Canary", [
		["2075-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2075-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2075-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2075-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2076" : helpers.makeTestYear("Atlantic/Canary", [
		["2076-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2076-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2076-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2076-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2077" : helpers.makeTestYear("Atlantic/Canary", [
		["2077-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2077-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2077-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2077-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2078" : helpers.makeTestYear("Atlantic/Canary", [
		["2078-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2078-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2078-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2078-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2079" : helpers.makeTestYear("Atlantic/Canary", [
		["2079-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2079-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2079-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2079-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2080" : helpers.makeTestYear("Atlantic/Canary", [
		["2080-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2080-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2080-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2080-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2081" : helpers.makeTestYear("Atlantic/Canary", [
		["2081-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2081-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2081-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2081-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2082" : helpers.makeTestYear("Atlantic/Canary", [
		["2082-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2082-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2082-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2082-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2083" : helpers.makeTestYear("Atlantic/Canary", [
		["2083-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2083-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2083-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2083-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2084" : helpers.makeTestYear("Atlantic/Canary", [
		["2084-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2084-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2084-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2084-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2085" : helpers.makeTestYear("Atlantic/Canary", [
		["2085-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2085-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2085-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2085-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2086" : helpers.makeTestYear("Atlantic/Canary", [
		["2086-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2086-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2086-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2086-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2087" : helpers.makeTestYear("Atlantic/Canary", [
		["2087-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2087-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2087-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2087-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2088" : helpers.makeTestYear("Atlantic/Canary", [
		["2088-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2088-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2088-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2088-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2089" : helpers.makeTestYear("Atlantic/Canary", [
		["2089-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2089-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2089-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2089-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2090" : helpers.makeTestYear("Atlantic/Canary", [
		["2090-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2090-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2090-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2090-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2091" : helpers.makeTestYear("Atlantic/Canary", [
		["2091-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2091-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2091-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2091-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2092" : helpers.makeTestYear("Atlantic/Canary", [
		["2092-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2092-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2092-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2092-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2093" : helpers.makeTestYear("Atlantic/Canary", [
		["2093-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2093-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2093-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2093-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2094" : helpers.makeTestYear("Atlantic/Canary", [
		["2094-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2094-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2094-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2094-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2095" : helpers.makeTestYear("Atlantic/Canary", [
		["2095-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2095-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2095-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2095-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2096" : helpers.makeTestYear("Atlantic/Canary", [
		["2096-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2096-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2096-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2096-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2097" : helpers.makeTestYear("Atlantic/Canary", [
		["2097-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2097-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2097-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2097-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2098" : helpers.makeTestYear("Atlantic/Canary", [
		["2098-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2098-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2098-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2098-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2099" : helpers.makeTestYear("Atlantic/Canary", [
		["2099-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2099-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2099-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2099-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2100" : helpers.makeTestYear("Atlantic/Canary", [
		["2100-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2100-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2100-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2100-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2101" : helpers.makeTestYear("Atlantic/Canary", [
		["2101-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2101-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2101-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2101-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2102" : helpers.makeTestYear("Atlantic/Canary", [
		["2102-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2102-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2102-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2102-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2103" : helpers.makeTestYear("Atlantic/Canary", [
		["2103-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2103-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2103-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2103-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2104" : helpers.makeTestYear("Atlantic/Canary", [
		["2104-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2104-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2104-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2104-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2105" : helpers.makeTestYear("Atlantic/Canary", [
		["2105-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2105-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2105-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2105-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2106" : helpers.makeTestYear("Atlantic/Canary", [
		["2106-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2106-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2106-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2106-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2107" : helpers.makeTestYear("Atlantic/Canary", [
		["2107-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2107-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2107-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2107-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2108" : helpers.makeTestYear("Atlantic/Canary", [
		["2108-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2108-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2108-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2108-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2109" : helpers.makeTestYear("Atlantic/Canary", [
		["2109-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2109-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2109-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2109-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2110" : helpers.makeTestYear("Atlantic/Canary", [
		["2110-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2110-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2110-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2110-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2111" : helpers.makeTestYear("Atlantic/Canary", [
		["2111-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2111-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2111-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2111-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2112" : helpers.makeTestYear("Atlantic/Canary", [
		["2112-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2112-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2112-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2112-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2113" : helpers.makeTestYear("Atlantic/Canary", [
		["2113-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2113-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2113-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2113-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2114" : helpers.makeTestYear("Atlantic/Canary", [
		["2114-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2114-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2114-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2114-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2115" : helpers.makeTestYear("Atlantic/Canary", [
		["2115-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2115-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2115-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2115-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2116" : helpers.makeTestYear("Atlantic/Canary", [
		["2116-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2116-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2116-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2116-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2117" : helpers.makeTestYear("Atlantic/Canary", [
		["2117-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2117-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2117-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2117-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2118" : helpers.makeTestYear("Atlantic/Canary", [
		["2118-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2118-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2118-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2118-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2119" : helpers.makeTestYear("Atlantic/Canary", [
		["2119-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2119-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2119-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2119-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2120" : helpers.makeTestYear("Atlantic/Canary", [
		["2120-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2120-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2120-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2120-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2121" : helpers.makeTestYear("Atlantic/Canary", [
		["2121-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2121-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2121-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2121-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2122" : helpers.makeTestYear("Atlantic/Canary", [
		["2122-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2122-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2122-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2122-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2123" : helpers.makeTestYear("Atlantic/Canary", [
		["2123-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2123-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2123-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2123-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2124" : helpers.makeTestYear("Atlantic/Canary", [
		["2124-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2124-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2124-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2124-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2125" : helpers.makeTestYear("Atlantic/Canary", [
		["2125-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2125-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2125-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2125-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2126" : helpers.makeTestYear("Atlantic/Canary", [
		["2126-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2126-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2126-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2126-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2127" : helpers.makeTestYear("Atlantic/Canary", [
		["2127-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2127-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2127-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2127-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2128" : helpers.makeTestYear("Atlantic/Canary", [
		["2128-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2128-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2128-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2128-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2129" : helpers.makeTestYear("Atlantic/Canary", [
		["2129-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2129-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2129-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2129-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2130" : helpers.makeTestYear("Atlantic/Canary", [
		["2130-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2130-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2130-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2130-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2131" : helpers.makeTestYear("Atlantic/Canary", [
		["2131-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2131-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2131-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2131-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2132" : helpers.makeTestYear("Atlantic/Canary", [
		["2132-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2132-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2132-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2132-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2133" : helpers.makeTestYear("Atlantic/Canary", [
		["2133-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2133-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2133-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2133-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2134" : helpers.makeTestYear("Atlantic/Canary", [
		["2134-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2134-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2134-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2134-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2135" : helpers.makeTestYear("Atlantic/Canary", [
		["2135-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2135-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2135-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2135-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2136" : helpers.makeTestYear("Atlantic/Canary", [
		["2136-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2136-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2136-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2136-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2137" : helpers.makeTestYear("Atlantic/Canary", [
		["2137-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2137-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2137-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2137-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2138" : helpers.makeTestYear("Atlantic/Canary", [
		["2138-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2138-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2138-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2138-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2139" : helpers.makeTestYear("Atlantic/Canary", [
		["2139-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2139-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2139-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2139-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2140" : helpers.makeTestYear("Atlantic/Canary", [
		["2140-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2140-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2140-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2140-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2141" : helpers.makeTestYear("Atlantic/Canary", [
		["2141-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2141-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2141-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2141-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2142" : helpers.makeTestYear("Atlantic/Canary", [
		["2142-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2142-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2142-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2142-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2143" : helpers.makeTestYear("Atlantic/Canary", [
		["2143-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2143-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2143-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2143-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2144" : helpers.makeTestYear("Atlantic/Canary", [
		["2144-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2144-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2144-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2144-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2145" : helpers.makeTestYear("Atlantic/Canary", [
		["2145-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2145-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2145-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2145-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2146" : helpers.makeTestYear("Atlantic/Canary", [
		["2146-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2146-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2146-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2146-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2147" : helpers.makeTestYear("Atlantic/Canary", [
		["2147-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2147-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2147-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2147-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2148" : helpers.makeTestYear("Atlantic/Canary", [
		["2148-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2148-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2148-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2148-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2149" : helpers.makeTestYear("Atlantic/Canary", [
		["2149-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2149-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2149-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2149-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2150" : helpers.makeTestYear("Atlantic/Canary", [
		["2150-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2150-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2150-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2150-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2151" : helpers.makeTestYear("Atlantic/Canary", [
		["2151-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2151-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2151-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2151-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2152" : helpers.makeTestYear("Atlantic/Canary", [
		["2152-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2152-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2152-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2152-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2153" : helpers.makeTestYear("Atlantic/Canary", [
		["2153-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2153-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2153-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2153-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2154" : helpers.makeTestYear("Atlantic/Canary", [
		["2154-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2154-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2154-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2154-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2155" : helpers.makeTestYear("Atlantic/Canary", [
		["2155-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2155-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2155-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2155-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2156" : helpers.makeTestYear("Atlantic/Canary", [
		["2156-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2156-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2156-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2156-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2157" : helpers.makeTestYear("Atlantic/Canary", [
		["2157-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2157-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2157-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2157-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2158" : helpers.makeTestYear("Atlantic/Canary", [
		["2158-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2158-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2158-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2158-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2159" : helpers.makeTestYear("Atlantic/Canary", [
		["2159-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2159-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2159-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2159-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2160" : helpers.makeTestYear("Atlantic/Canary", [
		["2160-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2160-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2160-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2160-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2161" : helpers.makeTestYear("Atlantic/Canary", [
		["2161-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2161-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2161-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2161-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2162" : helpers.makeTestYear("Atlantic/Canary", [
		["2162-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2162-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2162-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2162-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2163" : helpers.makeTestYear("Atlantic/Canary", [
		["2163-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2163-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2163-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2163-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2164" : helpers.makeTestYear("Atlantic/Canary", [
		["2164-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2164-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2164-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2164-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2165" : helpers.makeTestYear("Atlantic/Canary", [
		["2165-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2165-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2165-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2165-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2166" : helpers.makeTestYear("Atlantic/Canary", [
		["2166-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2166-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2166-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2166-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2167" : helpers.makeTestYear("Atlantic/Canary", [
		["2167-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2167-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2167-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2167-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2168" : helpers.makeTestYear("Atlantic/Canary", [
		["2168-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2168-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2168-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2168-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2169" : helpers.makeTestYear("Atlantic/Canary", [
		["2169-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2169-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2169-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2169-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2170" : helpers.makeTestYear("Atlantic/Canary", [
		["2170-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2170-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2170-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2170-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2171" : helpers.makeTestYear("Atlantic/Canary", [
		["2171-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2171-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2171-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2171-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2172" : helpers.makeTestYear("Atlantic/Canary", [
		["2172-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2172-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2172-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2172-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2173" : helpers.makeTestYear("Atlantic/Canary", [
		["2173-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2173-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2173-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2173-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2174" : helpers.makeTestYear("Atlantic/Canary", [
		["2174-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2174-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2174-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2174-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2175" : helpers.makeTestYear("Atlantic/Canary", [
		["2175-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2175-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2175-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2175-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2176" : helpers.makeTestYear("Atlantic/Canary", [
		["2176-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2176-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2176-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2176-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2177" : helpers.makeTestYear("Atlantic/Canary", [
		["2177-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2177-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2177-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2177-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2178" : helpers.makeTestYear("Atlantic/Canary", [
		["2178-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2178-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2178-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2178-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2179" : helpers.makeTestYear("Atlantic/Canary", [
		["2179-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2179-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2179-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2179-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2180" : helpers.makeTestYear("Atlantic/Canary", [
		["2180-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2180-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2180-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2180-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2181" : helpers.makeTestYear("Atlantic/Canary", [
		["2181-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2181-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2181-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2181-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2182" : helpers.makeTestYear("Atlantic/Canary", [
		["2182-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2182-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2182-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2182-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2183" : helpers.makeTestYear("Atlantic/Canary", [
		["2183-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2183-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2183-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2183-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2184" : helpers.makeTestYear("Atlantic/Canary", [
		["2184-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2184-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2184-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2184-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2185" : helpers.makeTestYear("Atlantic/Canary", [
		["2185-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2185-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2185-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2185-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2186" : helpers.makeTestYear("Atlantic/Canary", [
		["2186-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2186-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2186-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2186-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2187" : helpers.makeTestYear("Atlantic/Canary", [
		["2187-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2187-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2187-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2187-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2188" : helpers.makeTestYear("Atlantic/Canary", [
		["2188-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2188-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2188-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2188-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2189" : helpers.makeTestYear("Atlantic/Canary", [
		["2189-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2189-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2189-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2189-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2190" : helpers.makeTestYear("Atlantic/Canary", [
		["2190-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2190-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2190-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2190-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2191" : helpers.makeTestYear("Atlantic/Canary", [
		["2191-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2191-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2191-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2191-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2192" : helpers.makeTestYear("Atlantic/Canary", [
		["2192-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2192-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2192-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2192-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2193" : helpers.makeTestYear("Atlantic/Canary", [
		["2193-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2193-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2193-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2193-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2194" : helpers.makeTestYear("Atlantic/Canary", [
		["2194-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2194-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2194-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2194-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2195" : helpers.makeTestYear("Atlantic/Canary", [
		["2195-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2195-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2195-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2195-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2196" : helpers.makeTestYear("Atlantic/Canary", [
		["2196-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2196-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2196-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2196-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2197" : helpers.makeTestYear("Atlantic/Canary", [
		["2197-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2197-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2197-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2197-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2198" : helpers.makeTestYear("Atlantic/Canary", [
		["2198-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2198-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2198-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2198-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2199" : helpers.makeTestYear("Atlantic/Canary", [
		["2199-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2199-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2199-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2199-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2200" : helpers.makeTestYear("Atlantic/Canary", [
		["2200-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2200-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2200-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2200-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2201" : helpers.makeTestYear("Atlantic/Canary", [
		["2201-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2201-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2201-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2201-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2202" : helpers.makeTestYear("Atlantic/Canary", [
		["2202-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2202-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2202-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2202-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2203" : helpers.makeTestYear("Atlantic/Canary", [
		["2203-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2203-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2203-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2203-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2204" : helpers.makeTestYear("Atlantic/Canary", [
		["2204-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2204-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2204-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2204-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2205" : helpers.makeTestYear("Atlantic/Canary", [
		["2205-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2205-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2205-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2205-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2206" : helpers.makeTestYear("Atlantic/Canary", [
		["2206-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2206-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2206-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2206-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2207" : helpers.makeTestYear("Atlantic/Canary", [
		["2207-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2207-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2207-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2207-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2208" : helpers.makeTestYear("Atlantic/Canary", [
		["2208-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2208-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2208-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2208-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2209" : helpers.makeTestYear("Atlantic/Canary", [
		["2209-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2209-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2209-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2209-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2210" : helpers.makeTestYear("Atlantic/Canary", [
		["2210-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2210-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2210-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2210-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2211" : helpers.makeTestYear("Atlantic/Canary", [
		["2211-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2211-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2211-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2211-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2212" : helpers.makeTestYear("Atlantic/Canary", [
		["2212-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2212-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2212-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2212-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2213" : helpers.makeTestYear("Atlantic/Canary", [
		["2213-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2213-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2213-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2213-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2214" : helpers.makeTestYear("Atlantic/Canary", [
		["2214-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2214-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2214-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2214-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2215" : helpers.makeTestYear("Atlantic/Canary", [
		["2215-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2215-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2215-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2215-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2216" : helpers.makeTestYear("Atlantic/Canary", [
		["2216-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2216-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2216-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2216-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2217" : helpers.makeTestYear("Atlantic/Canary", [
		["2217-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2217-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2217-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2217-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2218" : helpers.makeTestYear("Atlantic/Canary", [
		["2218-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2218-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2218-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2218-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2219" : helpers.makeTestYear("Atlantic/Canary", [
		["2219-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2219-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2219-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2219-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2220" : helpers.makeTestYear("Atlantic/Canary", [
		["2220-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2220-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2220-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2220-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2221" : helpers.makeTestYear("Atlantic/Canary", [
		["2221-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2221-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2221-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2221-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2222" : helpers.makeTestYear("Atlantic/Canary", [
		["2222-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2222-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2222-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2222-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2223" : helpers.makeTestYear("Atlantic/Canary", [
		["2223-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2223-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2223-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2223-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2224" : helpers.makeTestYear("Atlantic/Canary", [
		["2224-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2224-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2224-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2224-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2225" : helpers.makeTestYear("Atlantic/Canary", [
		["2225-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2225-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2225-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2225-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2226" : helpers.makeTestYear("Atlantic/Canary", [
		["2226-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2226-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2226-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2226-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2227" : helpers.makeTestYear("Atlantic/Canary", [
		["2227-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2227-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2227-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2227-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2228" : helpers.makeTestYear("Atlantic/Canary", [
		["2228-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2228-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2228-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2228-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2229" : helpers.makeTestYear("Atlantic/Canary", [
		["2229-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2229-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2229-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2229-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2230" : helpers.makeTestYear("Atlantic/Canary", [
		["2230-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2230-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2230-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2230-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2231" : helpers.makeTestYear("Atlantic/Canary", [
		["2231-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2231-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2231-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2231-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2232" : helpers.makeTestYear("Atlantic/Canary", [
		["2232-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2232-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2232-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2232-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2233" : helpers.makeTestYear("Atlantic/Canary", [
		["2233-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2233-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2233-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2233-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2234" : helpers.makeTestYear("Atlantic/Canary", [
		["2234-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2234-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2234-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2234-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2235" : helpers.makeTestYear("Atlantic/Canary", [
		["2235-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2235-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2235-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2235-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2236" : helpers.makeTestYear("Atlantic/Canary", [
		["2236-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2236-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2236-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2236-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2237" : helpers.makeTestYear("Atlantic/Canary", [
		["2237-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2237-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2237-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2237-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2238" : helpers.makeTestYear("Atlantic/Canary", [
		["2238-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2238-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2238-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2238-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2239" : helpers.makeTestYear("Atlantic/Canary", [
		["2239-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2239-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2239-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2239-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2240" : helpers.makeTestYear("Atlantic/Canary", [
		["2240-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2240-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2240-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2240-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2241" : helpers.makeTestYear("Atlantic/Canary", [
		["2241-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2241-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2241-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2241-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2242" : helpers.makeTestYear("Atlantic/Canary", [
		["2242-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2242-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2242-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2242-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2243" : helpers.makeTestYear("Atlantic/Canary", [
		["2243-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2243-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2243-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2243-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2244" : helpers.makeTestYear("Atlantic/Canary", [
		["2244-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2244-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2244-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2244-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2245" : helpers.makeTestYear("Atlantic/Canary", [
		["2245-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2245-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2245-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2245-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2246" : helpers.makeTestYear("Atlantic/Canary", [
		["2246-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2246-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2246-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2246-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2247" : helpers.makeTestYear("Atlantic/Canary", [
		["2247-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2247-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2247-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2247-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2248" : helpers.makeTestYear("Atlantic/Canary", [
		["2248-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2248-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2248-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2248-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2249" : helpers.makeTestYear("Atlantic/Canary", [
		["2249-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2249-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2249-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2249-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2250" : helpers.makeTestYear("Atlantic/Canary", [
		["2250-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2250-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2250-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2250-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2251" : helpers.makeTestYear("Atlantic/Canary", [
		["2251-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2251-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2251-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2251-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2252" : helpers.makeTestYear("Atlantic/Canary", [
		["2252-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2252-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2252-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2252-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2253" : helpers.makeTestYear("Atlantic/Canary", [
		["2253-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2253-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2253-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2253-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2254" : helpers.makeTestYear("Atlantic/Canary", [
		["2254-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2254-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2254-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2254-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2255" : helpers.makeTestYear("Atlantic/Canary", [
		["2255-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2255-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2255-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2255-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2256" : helpers.makeTestYear("Atlantic/Canary", [
		["2256-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2256-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2256-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2256-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2257" : helpers.makeTestYear("Atlantic/Canary", [
		["2257-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2257-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2257-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2257-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2258" : helpers.makeTestYear("Atlantic/Canary", [
		["2258-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2258-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2258-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2258-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2259" : helpers.makeTestYear("Atlantic/Canary", [
		["2259-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2259-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2259-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2259-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2260" : helpers.makeTestYear("Atlantic/Canary", [
		["2260-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2260-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2260-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2260-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2261" : helpers.makeTestYear("Atlantic/Canary", [
		["2261-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2261-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2261-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2261-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2262" : helpers.makeTestYear("Atlantic/Canary", [
		["2262-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2262-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2262-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2262-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2263" : helpers.makeTestYear("Atlantic/Canary", [
		["2263-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2263-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2263-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2263-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2264" : helpers.makeTestYear("Atlantic/Canary", [
		["2264-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2264-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2264-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2264-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2265" : helpers.makeTestYear("Atlantic/Canary", [
		["2265-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2265-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2265-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2265-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2266" : helpers.makeTestYear("Atlantic/Canary", [
		["2266-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2266-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2266-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2266-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2267" : helpers.makeTestYear("Atlantic/Canary", [
		["2267-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2267-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2267-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2267-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2268" : helpers.makeTestYear("Atlantic/Canary", [
		["2268-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2268-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2268-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2268-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2269" : helpers.makeTestYear("Atlantic/Canary", [
		["2269-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2269-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2269-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2269-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2270" : helpers.makeTestYear("Atlantic/Canary", [
		["2270-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2270-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2270-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2270-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2271" : helpers.makeTestYear("Atlantic/Canary", [
		["2271-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2271-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2271-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2271-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2272" : helpers.makeTestYear("Atlantic/Canary", [
		["2272-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2272-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2272-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2272-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2273" : helpers.makeTestYear("Atlantic/Canary", [
		["2273-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2273-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2273-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2273-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2274" : helpers.makeTestYear("Atlantic/Canary", [
		["2274-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2274-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2274-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2274-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2275" : helpers.makeTestYear("Atlantic/Canary", [
		["2275-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2275-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2275-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2275-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2276" : helpers.makeTestYear("Atlantic/Canary", [
		["2276-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2276-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2276-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2276-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2277" : helpers.makeTestYear("Atlantic/Canary", [
		["2277-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2277-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2277-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2277-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2278" : helpers.makeTestYear("Atlantic/Canary", [
		["2278-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2278-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2278-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2278-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2279" : helpers.makeTestYear("Atlantic/Canary", [
		["2279-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2279-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2279-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2279-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2280" : helpers.makeTestYear("Atlantic/Canary", [
		["2280-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2280-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2280-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2280-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2281" : helpers.makeTestYear("Atlantic/Canary", [
		["2281-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2281-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2281-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2281-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2282" : helpers.makeTestYear("Atlantic/Canary", [
		["2282-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2282-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2282-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2282-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2283" : helpers.makeTestYear("Atlantic/Canary", [
		["2283-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2283-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2283-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2283-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2284" : helpers.makeTestYear("Atlantic/Canary", [
		["2284-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2284-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2284-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2284-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2285" : helpers.makeTestYear("Atlantic/Canary", [
		["2285-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2285-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2285-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2285-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2286" : helpers.makeTestYear("Atlantic/Canary", [
		["2286-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2286-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2286-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2286-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2287" : helpers.makeTestYear("Atlantic/Canary", [
		["2287-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2287-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2287-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2287-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2288" : helpers.makeTestYear("Atlantic/Canary", [
		["2288-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2288-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2288-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2288-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2289" : helpers.makeTestYear("Atlantic/Canary", [
		["2289-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2289-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2289-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2289-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2290" : helpers.makeTestYear("Atlantic/Canary", [
		["2290-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2290-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2290-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2290-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2291" : helpers.makeTestYear("Atlantic/Canary", [
		["2291-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2291-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2291-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2291-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2292" : helpers.makeTestYear("Atlantic/Canary", [
		["2292-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2292-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2292-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2292-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2293" : helpers.makeTestYear("Atlantic/Canary", [
		["2293-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2293-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2293-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2293-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2294" : helpers.makeTestYear("Atlantic/Canary", [
		["2294-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2294-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2294-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2294-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2295" : helpers.makeTestYear("Atlantic/Canary", [
		["2295-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2295-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2295-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2295-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2296" : helpers.makeTestYear("Atlantic/Canary", [
		["2296-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2296-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2296-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2296-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2297" : helpers.makeTestYear("Atlantic/Canary", [
		["2297-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2297-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2297-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2297-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2298" : helpers.makeTestYear("Atlantic/Canary", [
		["2298-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2298-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2298-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2298-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2299" : helpers.makeTestYear("Atlantic/Canary", [
		["2299-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2299-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2299-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2299-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2300" : helpers.makeTestYear("Atlantic/Canary", [
		["2300-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2300-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2300-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2300-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2301" : helpers.makeTestYear("Atlantic/Canary", [
		["2301-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2301-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2301-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2301-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2302" : helpers.makeTestYear("Atlantic/Canary", [
		["2302-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2302-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2302-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2302-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2303" : helpers.makeTestYear("Atlantic/Canary", [
		["2303-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2303-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2303-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2303-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2304" : helpers.makeTestYear("Atlantic/Canary", [
		["2304-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2304-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2304-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2304-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2305" : helpers.makeTestYear("Atlantic/Canary", [
		["2305-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2305-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2305-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2305-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2306" : helpers.makeTestYear("Atlantic/Canary", [
		["2306-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2306-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2306-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2306-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2307" : helpers.makeTestYear("Atlantic/Canary", [
		["2307-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2307-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2307-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2307-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2308" : helpers.makeTestYear("Atlantic/Canary", [
		["2308-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2308-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2308-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2308-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2309" : helpers.makeTestYear("Atlantic/Canary", [
		["2309-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2309-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2309-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2309-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2310" : helpers.makeTestYear("Atlantic/Canary", [
		["2310-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2310-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2310-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2310-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2311" : helpers.makeTestYear("Atlantic/Canary", [
		["2311-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2311-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2311-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2311-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2312" : helpers.makeTestYear("Atlantic/Canary", [
		["2312-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2312-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2312-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2312-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2313" : helpers.makeTestYear("Atlantic/Canary", [
		["2313-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2313-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2313-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2313-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2314" : helpers.makeTestYear("Atlantic/Canary", [
		["2314-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2314-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2314-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2314-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2315" : helpers.makeTestYear("Atlantic/Canary", [
		["2315-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2315-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2315-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2315-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2316" : helpers.makeTestYear("Atlantic/Canary", [
		["2316-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2316-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2316-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2316-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2317" : helpers.makeTestYear("Atlantic/Canary", [
		["2317-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2317-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2317-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2317-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2318" : helpers.makeTestYear("Atlantic/Canary", [
		["2318-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2318-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2318-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2318-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2319" : helpers.makeTestYear("Atlantic/Canary", [
		["2319-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2319-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2319-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2319-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2320" : helpers.makeTestYear("Atlantic/Canary", [
		["2320-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2320-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2320-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2320-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2321" : helpers.makeTestYear("Atlantic/Canary", [
		["2321-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2321-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2321-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2321-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2322" : helpers.makeTestYear("Atlantic/Canary", [
		["2322-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2322-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2322-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2322-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2323" : helpers.makeTestYear("Atlantic/Canary", [
		["2323-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2323-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2323-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2323-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2324" : helpers.makeTestYear("Atlantic/Canary", [
		["2324-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2324-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2324-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2324-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2325" : helpers.makeTestYear("Atlantic/Canary", [
		["2325-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2325-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2325-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2325-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2326" : helpers.makeTestYear("Atlantic/Canary", [
		["2326-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2326-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2326-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2326-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2327" : helpers.makeTestYear("Atlantic/Canary", [
		["2327-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2327-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2327-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2327-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2328" : helpers.makeTestYear("Atlantic/Canary", [
		["2328-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2328-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2328-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2328-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2329" : helpers.makeTestYear("Atlantic/Canary", [
		["2329-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2329-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2329-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2329-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2330" : helpers.makeTestYear("Atlantic/Canary", [
		["2330-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2330-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2330-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2330-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2331" : helpers.makeTestYear("Atlantic/Canary", [
		["2331-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2331-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2331-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2331-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2332" : helpers.makeTestYear("Atlantic/Canary", [
		["2332-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2332-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2332-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2332-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2333" : helpers.makeTestYear("Atlantic/Canary", [
		["2333-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2333-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2333-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2333-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2334" : helpers.makeTestYear("Atlantic/Canary", [
		["2334-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2334-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2334-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2334-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2335" : helpers.makeTestYear("Atlantic/Canary", [
		["2335-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2335-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2335-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2335-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2336" : helpers.makeTestYear("Atlantic/Canary", [
		["2336-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2336-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2336-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2336-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2337" : helpers.makeTestYear("Atlantic/Canary", [
		["2337-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2337-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2337-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2337-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2338" : helpers.makeTestYear("Atlantic/Canary", [
		["2338-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2338-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2338-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2338-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2339" : helpers.makeTestYear("Atlantic/Canary", [
		["2339-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2339-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2339-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2339-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2340" : helpers.makeTestYear("Atlantic/Canary", [
		["2340-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2340-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2340-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2340-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2341" : helpers.makeTestYear("Atlantic/Canary", [
		["2341-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2341-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2341-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2341-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2342" : helpers.makeTestYear("Atlantic/Canary", [
		["2342-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2342-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2342-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2342-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2343" : helpers.makeTestYear("Atlantic/Canary", [
		["2343-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2343-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2343-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2343-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2344" : helpers.makeTestYear("Atlantic/Canary", [
		["2344-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2344-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2344-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2344-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2345" : helpers.makeTestYear("Atlantic/Canary", [
		["2345-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2345-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2345-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2345-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2346" : helpers.makeTestYear("Atlantic/Canary", [
		["2346-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2346-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2346-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2346-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2347" : helpers.makeTestYear("Atlantic/Canary", [
		["2347-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2347-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2347-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2347-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2348" : helpers.makeTestYear("Atlantic/Canary", [
		["2348-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2348-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2348-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2348-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2349" : helpers.makeTestYear("Atlantic/Canary", [
		["2349-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2349-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2349-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2349-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2350" : helpers.makeTestYear("Atlantic/Canary", [
		["2350-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2350-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2350-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2350-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2351" : helpers.makeTestYear("Atlantic/Canary", [
		["2351-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2351-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2351-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2351-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2352" : helpers.makeTestYear("Atlantic/Canary", [
		["2352-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2352-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2352-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2352-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2353" : helpers.makeTestYear("Atlantic/Canary", [
		["2353-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2353-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2353-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2353-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2354" : helpers.makeTestYear("Atlantic/Canary", [
		["2354-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2354-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2354-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2354-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2355" : helpers.makeTestYear("Atlantic/Canary", [
		["2355-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2355-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2355-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2355-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2356" : helpers.makeTestYear("Atlantic/Canary", [
		["2356-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2356-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2356-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2356-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2357" : helpers.makeTestYear("Atlantic/Canary", [
		["2357-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2357-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2357-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2357-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2358" : helpers.makeTestYear("Atlantic/Canary", [
		["2358-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2358-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2358-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2358-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2359" : helpers.makeTestYear("Atlantic/Canary", [
		["2359-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2359-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2359-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2359-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2360" : helpers.makeTestYear("Atlantic/Canary", [
		["2360-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2360-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2360-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2360-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2361" : helpers.makeTestYear("Atlantic/Canary", [
		["2361-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2361-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2361-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2361-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2362" : helpers.makeTestYear("Atlantic/Canary", [
		["2362-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2362-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2362-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2362-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2363" : helpers.makeTestYear("Atlantic/Canary", [
		["2363-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2363-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2363-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2363-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2364" : helpers.makeTestYear("Atlantic/Canary", [
		["2364-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2364-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2364-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2364-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2365" : helpers.makeTestYear("Atlantic/Canary", [
		["2365-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2365-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2365-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2365-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2366" : helpers.makeTestYear("Atlantic/Canary", [
		["2366-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2366-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2366-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2366-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2367" : helpers.makeTestYear("Atlantic/Canary", [
		["2367-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2367-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2367-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2367-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2368" : helpers.makeTestYear("Atlantic/Canary", [
		["2368-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2368-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2368-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2368-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2369" : helpers.makeTestYear("Atlantic/Canary", [
		["2369-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2369-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2369-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2369-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2370" : helpers.makeTestYear("Atlantic/Canary", [
		["2370-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2370-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2370-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2370-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2371" : helpers.makeTestYear("Atlantic/Canary", [
		["2371-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2371-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2371-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2371-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2372" : helpers.makeTestYear("Atlantic/Canary", [
		["2372-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2372-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2372-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2372-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2373" : helpers.makeTestYear("Atlantic/Canary", [
		["2373-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2373-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2373-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2373-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2374" : helpers.makeTestYear("Atlantic/Canary", [
		["2374-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2374-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2374-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2374-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2375" : helpers.makeTestYear("Atlantic/Canary", [
		["2375-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2375-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2375-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2375-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2376" : helpers.makeTestYear("Atlantic/Canary", [
		["2376-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2376-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2376-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2376-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2377" : helpers.makeTestYear("Atlantic/Canary", [
		["2377-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2377-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2377-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2377-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2378" : helpers.makeTestYear("Atlantic/Canary", [
		["2378-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2378-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2378-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2378-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2379" : helpers.makeTestYear("Atlantic/Canary", [
		["2379-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2379-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2379-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2379-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2380" : helpers.makeTestYear("Atlantic/Canary", [
		["2380-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2380-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2380-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2380-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2381" : helpers.makeTestYear("Atlantic/Canary", [
		["2381-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2381-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2381-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2381-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2382" : helpers.makeTestYear("Atlantic/Canary", [
		["2382-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2382-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2382-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2382-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2383" : helpers.makeTestYear("Atlantic/Canary", [
		["2383-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2383-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2383-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2383-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2384" : helpers.makeTestYear("Atlantic/Canary", [
		["2384-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2384-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2384-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2384-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2385" : helpers.makeTestYear("Atlantic/Canary", [
		["2385-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2385-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2385-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2385-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2386" : helpers.makeTestYear("Atlantic/Canary", [
		["2386-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2386-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2386-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2386-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2387" : helpers.makeTestYear("Atlantic/Canary", [
		["2387-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2387-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2387-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2387-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2388" : helpers.makeTestYear("Atlantic/Canary", [
		["2388-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2388-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2388-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2388-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2389" : helpers.makeTestYear("Atlantic/Canary", [
		["2389-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2389-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2389-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2389-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2390" : helpers.makeTestYear("Atlantic/Canary", [
		["2390-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2390-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2390-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2390-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2391" : helpers.makeTestYear("Atlantic/Canary", [
		["2391-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2391-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2391-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2391-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2392" : helpers.makeTestYear("Atlantic/Canary", [
		["2392-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2392-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2392-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2392-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2393" : helpers.makeTestYear("Atlantic/Canary", [
		["2393-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2393-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2393-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2393-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2394" : helpers.makeTestYear("Atlantic/Canary", [
		["2394-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2394-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2394-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2394-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2395" : helpers.makeTestYear("Atlantic/Canary", [
		["2395-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2395-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2395-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2395-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2396" : helpers.makeTestYear("Atlantic/Canary", [
		["2396-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2396-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2396-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2396-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2397" : helpers.makeTestYear("Atlantic/Canary", [
		["2397-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2397-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2397-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2397-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2398" : helpers.makeTestYear("Atlantic/Canary", [
		["2398-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2398-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2398-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2398-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2399" : helpers.makeTestYear("Atlantic/Canary", [
		["2399-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2399-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2399-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2399-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2400" : helpers.makeTestYear("Atlantic/Canary", [
		["2400-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2400-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2400-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2400-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2401" : helpers.makeTestYear("Atlantic/Canary", [
		["2401-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2401-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2401-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2401-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2402" : helpers.makeTestYear("Atlantic/Canary", [
		["2402-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2402-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2402-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2402-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2403" : helpers.makeTestYear("Atlantic/Canary", [
		["2403-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2403-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2403-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2403-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2404" : helpers.makeTestYear("Atlantic/Canary", [
		["2404-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2404-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2404-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2404-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2405" : helpers.makeTestYear("Atlantic/Canary", [
		["2405-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2405-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2405-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2405-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2406" : helpers.makeTestYear("Atlantic/Canary", [
		["2406-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2406-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2406-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2406-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2407" : helpers.makeTestYear("Atlantic/Canary", [
		["2407-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2407-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2407-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2407-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2408" : helpers.makeTestYear("Atlantic/Canary", [
		["2408-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2408-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2408-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2408-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2409" : helpers.makeTestYear("Atlantic/Canary", [
		["2409-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2409-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2409-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2409-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2410" : helpers.makeTestYear("Atlantic/Canary", [
		["2410-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2410-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2410-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2410-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2411" : helpers.makeTestYear("Atlantic/Canary", [
		["2411-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2411-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2411-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2411-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2412" : helpers.makeTestYear("Atlantic/Canary", [
		["2412-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2412-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2412-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2412-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2413" : helpers.makeTestYear("Atlantic/Canary", [
		["2413-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2413-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2413-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2413-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2414" : helpers.makeTestYear("Atlantic/Canary", [
		["2414-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2414-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2414-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2414-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2415" : helpers.makeTestYear("Atlantic/Canary", [
		["2415-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2415-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2415-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2415-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2416" : helpers.makeTestYear("Atlantic/Canary", [
		["2416-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2416-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2416-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2416-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2417" : helpers.makeTestYear("Atlantic/Canary", [
		["2417-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2417-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2417-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2417-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2418" : helpers.makeTestYear("Atlantic/Canary", [
		["2418-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2418-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2418-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2418-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2419" : helpers.makeTestYear("Atlantic/Canary", [
		["2419-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2419-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2419-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2419-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2420" : helpers.makeTestYear("Atlantic/Canary", [
		["2420-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2420-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2420-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2420-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2421" : helpers.makeTestYear("Atlantic/Canary", [
		["2421-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2421-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2421-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2421-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2422" : helpers.makeTestYear("Atlantic/Canary", [
		["2422-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2422-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2422-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2422-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2423" : helpers.makeTestYear("Atlantic/Canary", [
		["2423-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2423-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2423-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2423-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2424" : helpers.makeTestYear("Atlantic/Canary", [
		["2424-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2424-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2424-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2424-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2425" : helpers.makeTestYear("Atlantic/Canary", [
		["2425-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2425-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2425-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2425-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2426" : helpers.makeTestYear("Atlantic/Canary", [
		["2426-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2426-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2426-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2426-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2427" : helpers.makeTestYear("Atlantic/Canary", [
		["2427-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2427-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2427-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2427-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2428" : helpers.makeTestYear("Atlantic/Canary", [
		["2428-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2428-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2428-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2428-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2429" : helpers.makeTestYear("Atlantic/Canary", [
		["2429-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2429-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2429-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2429-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2430" : helpers.makeTestYear("Atlantic/Canary", [
		["2430-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2430-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2430-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2430-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2431" : helpers.makeTestYear("Atlantic/Canary", [
		["2431-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2431-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2431-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2431-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2432" : helpers.makeTestYear("Atlantic/Canary", [
		["2432-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2432-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2432-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2432-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2433" : helpers.makeTestYear("Atlantic/Canary", [
		["2433-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2433-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2433-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2433-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2434" : helpers.makeTestYear("Atlantic/Canary", [
		["2434-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2434-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2434-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2434-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2435" : helpers.makeTestYear("Atlantic/Canary", [
		["2435-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2435-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2435-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2435-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2436" : helpers.makeTestYear("Atlantic/Canary", [
		["2436-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2436-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2436-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2436-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2437" : helpers.makeTestYear("Atlantic/Canary", [
		["2437-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2437-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2437-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2437-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2438" : helpers.makeTestYear("Atlantic/Canary", [
		["2438-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2438-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2438-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2438-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2439" : helpers.makeTestYear("Atlantic/Canary", [
		["2439-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2439-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2439-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2439-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2440" : helpers.makeTestYear("Atlantic/Canary", [
		["2440-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2440-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2440-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2440-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2441" : helpers.makeTestYear("Atlantic/Canary", [
		["2441-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2441-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2441-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2441-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2442" : helpers.makeTestYear("Atlantic/Canary", [
		["2442-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2442-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2442-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2442-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2443" : helpers.makeTestYear("Atlantic/Canary", [
		["2443-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2443-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2443-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2443-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2444" : helpers.makeTestYear("Atlantic/Canary", [
		["2444-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2444-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2444-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2444-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2445" : helpers.makeTestYear("Atlantic/Canary", [
		["2445-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2445-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2445-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2445-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2446" : helpers.makeTestYear("Atlantic/Canary", [
		["2446-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2446-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2446-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2446-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2447" : helpers.makeTestYear("Atlantic/Canary", [
		["2447-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2447-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2447-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2447-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2448" : helpers.makeTestYear("Atlantic/Canary", [
		["2448-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2448-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2448-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2448-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2449" : helpers.makeTestYear("Atlantic/Canary", [
		["2449-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2449-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2449-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2449-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2450" : helpers.makeTestYear("Atlantic/Canary", [
		["2450-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2450-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2450-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2450-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2451" : helpers.makeTestYear("Atlantic/Canary", [
		["2451-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2451-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2451-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2451-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2452" : helpers.makeTestYear("Atlantic/Canary", [
		["2452-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2452-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2452-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2452-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2453" : helpers.makeTestYear("Atlantic/Canary", [
		["2453-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2453-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2453-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2453-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2454" : helpers.makeTestYear("Atlantic/Canary", [
		["2454-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2454-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2454-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2454-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2455" : helpers.makeTestYear("Atlantic/Canary", [
		["2455-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2455-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2455-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2455-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2456" : helpers.makeTestYear("Atlantic/Canary", [
		["2456-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2456-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2456-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2456-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2457" : helpers.makeTestYear("Atlantic/Canary", [
		["2457-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2457-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2457-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2457-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2458" : helpers.makeTestYear("Atlantic/Canary", [
		["2458-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2458-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2458-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2458-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2459" : helpers.makeTestYear("Atlantic/Canary", [
		["2459-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2459-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2459-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2459-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2460" : helpers.makeTestYear("Atlantic/Canary", [
		["2460-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2460-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2460-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2460-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2461" : helpers.makeTestYear("Atlantic/Canary", [
		["2461-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2461-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2461-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2461-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2462" : helpers.makeTestYear("Atlantic/Canary", [
		["2462-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2462-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2462-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2462-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2463" : helpers.makeTestYear("Atlantic/Canary", [
		["2463-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2463-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2463-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2463-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2464" : helpers.makeTestYear("Atlantic/Canary", [
		["2464-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2464-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2464-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2464-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2465" : helpers.makeTestYear("Atlantic/Canary", [
		["2465-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2465-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2465-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2465-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2466" : helpers.makeTestYear("Atlantic/Canary", [
		["2466-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2466-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2466-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2466-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2467" : helpers.makeTestYear("Atlantic/Canary", [
		["2467-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2467-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2467-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2467-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2468" : helpers.makeTestYear("Atlantic/Canary", [
		["2468-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2468-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2468-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2468-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2469" : helpers.makeTestYear("Atlantic/Canary", [
		["2469-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2469-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2469-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2469-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2470" : helpers.makeTestYear("Atlantic/Canary", [
		["2470-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2470-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2470-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2470-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2471" : helpers.makeTestYear("Atlantic/Canary", [
		["2471-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2471-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2471-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2471-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2472" : helpers.makeTestYear("Atlantic/Canary", [
		["2472-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2472-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2472-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2472-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2473" : helpers.makeTestYear("Atlantic/Canary", [
		["2473-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2473-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2473-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2473-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2474" : helpers.makeTestYear("Atlantic/Canary", [
		["2474-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2474-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2474-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2474-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2475" : helpers.makeTestYear("Atlantic/Canary", [
		["2475-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2475-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2475-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2475-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2476" : helpers.makeTestYear("Atlantic/Canary", [
		["2476-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2476-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2476-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2476-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2477" : helpers.makeTestYear("Atlantic/Canary", [
		["2477-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2477-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2477-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2477-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2478" : helpers.makeTestYear("Atlantic/Canary", [
		["2478-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2478-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2478-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2478-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2479" : helpers.makeTestYear("Atlantic/Canary", [
		["2479-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2479-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2479-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2479-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2480" : helpers.makeTestYear("Atlantic/Canary", [
		["2480-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2480-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2480-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2480-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2481" : helpers.makeTestYear("Atlantic/Canary", [
		["2481-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2481-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2481-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2481-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2482" : helpers.makeTestYear("Atlantic/Canary", [
		["2482-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2482-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2482-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2482-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2483" : helpers.makeTestYear("Atlantic/Canary", [
		["2483-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2483-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2483-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2483-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2484" : helpers.makeTestYear("Atlantic/Canary", [
		["2484-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2484-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2484-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2484-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2485" : helpers.makeTestYear("Atlantic/Canary", [
		["2485-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2485-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2485-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2485-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2486" : helpers.makeTestYear("Atlantic/Canary", [
		["2486-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2486-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2486-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2486-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2487" : helpers.makeTestYear("Atlantic/Canary", [
		["2487-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2487-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2487-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2487-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2488" : helpers.makeTestYear("Atlantic/Canary", [
		["2488-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2488-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2488-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2488-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2489" : helpers.makeTestYear("Atlantic/Canary", [
		["2489-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2489-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2489-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2489-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2490" : helpers.makeTestYear("Atlantic/Canary", [
		["2490-03-26T00:59:59+00:00", "00:59:59", "WET", 0],
		["2490-03-26T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2490-10-29T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2490-10-29T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2491" : helpers.makeTestYear("Atlantic/Canary", [
		["2491-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2491-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2491-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2491-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2492" : helpers.makeTestYear("Atlantic/Canary", [
		["2492-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2492-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2492-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2492-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2493" : helpers.makeTestYear("Atlantic/Canary", [
		["2493-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2493-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2493-10-25T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2493-10-25T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2494" : helpers.makeTestYear("Atlantic/Canary", [
		["2494-03-28T00:59:59+00:00", "00:59:59", "WET", 0],
		["2494-03-28T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2494-10-31T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2494-10-31T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2495" : helpers.makeTestYear("Atlantic/Canary", [
		["2495-03-27T00:59:59+00:00", "00:59:59", "WET", 0],
		["2495-03-27T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2495-10-30T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2495-10-30T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2496" : helpers.makeTestYear("Atlantic/Canary", [
		["2496-03-25T00:59:59+00:00", "00:59:59", "WET", 0],
		["2496-03-25T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2496-10-28T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2496-10-28T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2497" : helpers.makeTestYear("Atlantic/Canary", [
		["2497-03-31T00:59:59+00:00", "00:59:59", "WET", 0],
		["2497-03-31T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2497-10-27T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2497-10-27T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2498" : helpers.makeTestYear("Atlantic/Canary", [
		["2498-03-30T00:59:59+00:00", "00:59:59", "WET", 0],
		["2498-03-30T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2498-10-26T00:59:59+00:00", "01:59:59", "WEST", -60],
		["2498-10-26T01:00:00+00:00", "01:00:00", "WET", 0]
	]),

	"2499" : helpers.makeTestYear("Atlantic/Canary", [
		["2499-03-29T00:59:59+00:00", "00:59:59", "WET", 0],
		["2499-03-29T01:00:00+00:00", "02:00:00", "WEST", -60],
		["2499-10-25T00:59:59+00:00", "01:59:59", "WEST", -60]
	])
};