#!/bin/bash
. $(dirname $0)/common.inc

# Skip if libc is musl
is_musl && skip

cat <<'EOF' | $CC -c -o $t/a.o -x assembler -
.globl fn
fn:
  movabs main, %rax
  ret
EOF

cat <<EOF | $CC -c -o $t/b.o -fPIC -xc -
void fn();
int main() { fn(); }
EOF

$CC -B. -o $t/exe $t/a.o $t/b.o -pie -Wl,-warn-textrel >& $t/log
grep 'relocation against symbol `main'\'' in read-only section' $t/log
grep 'creating a DT_TEXTREL in an output file' $t/log
