// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/gaming/v1beta/game_server_clusters.proto

package gaming

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for GameServerClustersService.ListGameServerClusters.
type ListGameServerClustersRequest struct {
	// Required. The parent resource name. Uses the form:
	// "projects/{project}/locations/{location}/realms/{realm}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.  If unspecified, server
	// will pick an appropriate default. Server may return fewer items than
	// requested. A caller should only rely on response's
	// [next_page_token][google.cloud.gaming.v1beta.ListGameServerClustersResponse.next_page_token] to
	// determine if there are more GameServerClusters left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to apply to list results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specifies the ordering of results following syntax at
	// https://cloud.google.com/apis/design/design_patterns#sorting_order.
	OrderBy              string   `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListGameServerClustersRequest) Reset()         { *m = ListGameServerClustersRequest{} }
func (m *ListGameServerClustersRequest) String() string { return proto.CompactTextString(m) }
func (*ListGameServerClustersRequest) ProtoMessage()    {}
func (*ListGameServerClustersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{0}
}

func (m *ListGameServerClustersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGameServerClustersRequest.Unmarshal(m, b)
}
func (m *ListGameServerClustersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGameServerClustersRequest.Marshal(b, m, deterministic)
}
func (m *ListGameServerClustersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGameServerClustersRequest.Merge(m, src)
}
func (m *ListGameServerClustersRequest) XXX_Size() int {
	return xxx_messageInfo_ListGameServerClustersRequest.Size(m)
}
func (m *ListGameServerClustersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGameServerClustersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListGameServerClustersRequest proto.InternalMessageInfo

func (m *ListGameServerClustersRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListGameServerClustersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListGameServerClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListGameServerClustersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListGameServerClustersRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// Response message for GameServerClustersService.ListGameServerClusters.
type ListGameServerClustersResponse struct {
	// The list of Game Server Clusters.
	GameServerClusters []*GameServerCluster `protobuf:"bytes,1,rep,name=game_server_clusters,json=gameServerClusters,proto3" json:"game_server_clusters,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// List of Locations that could not be reached.
	Unreachable          []string `protobuf:"bytes,4,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListGameServerClustersResponse) Reset()         { *m = ListGameServerClustersResponse{} }
func (m *ListGameServerClustersResponse) String() string { return proto.CompactTextString(m) }
func (*ListGameServerClustersResponse) ProtoMessage()    {}
func (*ListGameServerClustersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{1}
}

func (m *ListGameServerClustersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGameServerClustersResponse.Unmarshal(m, b)
}
func (m *ListGameServerClustersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGameServerClustersResponse.Marshal(b, m, deterministic)
}
func (m *ListGameServerClustersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGameServerClustersResponse.Merge(m, src)
}
func (m *ListGameServerClustersResponse) XXX_Size() int {
	return xxx_messageInfo_ListGameServerClustersResponse.Size(m)
}
func (m *ListGameServerClustersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGameServerClustersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListGameServerClustersResponse proto.InternalMessageInfo

func (m *ListGameServerClustersResponse) GetGameServerClusters() []*GameServerCluster {
	if m != nil {
		return m.GameServerClusters
	}
	return nil
}

func (m *ListGameServerClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListGameServerClustersResponse) GetUnreachable() []string {
	if m != nil {
		return m.Unreachable
	}
	return nil
}

// Request message for GameServerClustersService.GetGameServerCluster.
type GetGameServerClusterRequest struct {
	// Required. The name of the Game Server Cluster to retrieve. Uses the form:
	//
	// `projects/{project}/locations/{location}/realms/{realm-id}/gameServerClusters/{cluster}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetGameServerClusterRequest) Reset()         { *m = GetGameServerClusterRequest{} }
func (m *GetGameServerClusterRequest) String() string { return proto.CompactTextString(m) }
func (*GetGameServerClusterRequest) ProtoMessage()    {}
func (*GetGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{2}
}

func (m *GetGameServerClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGameServerClusterRequest.Unmarshal(m, b)
}
func (m *GetGameServerClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGameServerClusterRequest.Marshal(b, m, deterministic)
}
func (m *GetGameServerClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGameServerClusterRequest.Merge(m, src)
}
func (m *GetGameServerClusterRequest) XXX_Size() int {
	return xxx_messageInfo_GetGameServerClusterRequest.Size(m)
}
func (m *GetGameServerClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGameServerClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetGameServerClusterRequest proto.InternalMessageInfo

func (m *GetGameServerClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for GameServerClustersService.CreateGameServerCluster.
type CreateGameServerClusterRequest struct {
	// Required. The parent resource name. Uses the form:
	// `projects/{project}/locations/{location}/realms/{realm-id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the Game Server Cluster resource to be created.
	GameServerClusterId string `protobuf:"bytes,2,opt,name=game_server_cluster_id,json=gameServerClusterId,proto3" json:"game_server_cluster_id,omitempty"`
	// Required. The Game Server Cluster resource to be created.
	GameServerCluster    *GameServerCluster `protobuf:"bytes,3,opt,name=game_server_cluster,json=gameServerCluster,proto3" json:"game_server_cluster,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *CreateGameServerClusterRequest) Reset()         { *m = CreateGameServerClusterRequest{} }
func (m *CreateGameServerClusterRequest) String() string { return proto.CompactTextString(m) }
func (*CreateGameServerClusterRequest) ProtoMessage()    {}
func (*CreateGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{3}
}

func (m *CreateGameServerClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateGameServerClusterRequest.Unmarshal(m, b)
}
func (m *CreateGameServerClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateGameServerClusterRequest.Marshal(b, m, deterministic)
}
func (m *CreateGameServerClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateGameServerClusterRequest.Merge(m, src)
}
func (m *CreateGameServerClusterRequest) XXX_Size() int {
	return xxx_messageInfo_CreateGameServerClusterRequest.Size(m)
}
func (m *CreateGameServerClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateGameServerClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateGameServerClusterRequest proto.InternalMessageInfo

func (m *CreateGameServerClusterRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateGameServerClusterRequest) GetGameServerClusterId() string {
	if m != nil {
		return m.GameServerClusterId
	}
	return ""
}

func (m *CreateGameServerClusterRequest) GetGameServerCluster() *GameServerCluster {
	if m != nil {
		return m.GameServerCluster
	}
	return nil
}

// Request message for GameServerClustersService.PreviewCreateGameServerCluster.
type PreviewCreateGameServerClusterRequest struct {
	// Required. The parent resource name. Uses the form:
	// `projects/{project}/locations/{location}/realms/{realm}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the Game Server Cluster resource to be created.
	GameServerClusterId string `protobuf:"bytes,2,opt,name=game_server_cluster_id,json=gameServerClusterId,proto3" json:"game_server_cluster_id,omitempty"`
	// Required. The Game Server Cluster resource to be created.
	GameServerCluster *GameServerCluster `protobuf:"bytes,3,opt,name=game_server_cluster,json=gameServerCluster,proto3" json:"game_server_cluster,omitempty"`
	// Optional. The target timestamp to compute the preview.
	PreviewTime          *timestamp.Timestamp `protobuf:"bytes,4,opt,name=preview_time,json=previewTime,proto3" json:"preview_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PreviewCreateGameServerClusterRequest) Reset()         { *m = PreviewCreateGameServerClusterRequest{} }
func (m *PreviewCreateGameServerClusterRequest) String() string { return proto.CompactTextString(m) }
func (*PreviewCreateGameServerClusterRequest) ProtoMessage()    {}
func (*PreviewCreateGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{4}
}

func (m *PreviewCreateGameServerClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PreviewCreateGameServerClusterRequest.Unmarshal(m, b)
}
func (m *PreviewCreateGameServerClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PreviewCreateGameServerClusterRequest.Marshal(b, m, deterministic)
}
func (m *PreviewCreateGameServerClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreviewCreateGameServerClusterRequest.Merge(m, src)
}
func (m *PreviewCreateGameServerClusterRequest) XXX_Size() int {
	return xxx_messageInfo_PreviewCreateGameServerClusterRequest.Size(m)
}
func (m *PreviewCreateGameServerClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PreviewCreateGameServerClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PreviewCreateGameServerClusterRequest proto.InternalMessageInfo

func (m *PreviewCreateGameServerClusterRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *PreviewCreateGameServerClusterRequest) GetGameServerClusterId() string {
	if m != nil {
		return m.GameServerClusterId
	}
	return ""
}

func (m *PreviewCreateGameServerClusterRequest) GetGameServerCluster() *GameServerCluster {
	if m != nil {
		return m.GameServerCluster
	}
	return nil
}

func (m *PreviewCreateGameServerClusterRequest) GetPreviewTime() *timestamp.Timestamp {
	if m != nil {
		return m.PreviewTime
	}
	return nil
}

// Response message for
// GameServerClustersService.PreviewCreateGameServerCluster.
type PreviewCreateGameServerClusterResponse struct {
	// The ETag of the game server cluster.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The target state.
	TargetState          *TargetState `protobuf:"bytes,3,opt,name=target_state,json=targetState,proto3" json:"target_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PreviewCreateGameServerClusterResponse) Reset() {
	*m = PreviewCreateGameServerClusterResponse{}
}
func (m *PreviewCreateGameServerClusterResponse) String() string { return proto.CompactTextString(m) }
func (*PreviewCreateGameServerClusterResponse) ProtoMessage()    {}
func (*PreviewCreateGameServerClusterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{5}
}

func (m *PreviewCreateGameServerClusterResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PreviewCreateGameServerClusterResponse.Unmarshal(m, b)
}
func (m *PreviewCreateGameServerClusterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PreviewCreateGameServerClusterResponse.Marshal(b, m, deterministic)
}
func (m *PreviewCreateGameServerClusterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreviewCreateGameServerClusterResponse.Merge(m, src)
}
func (m *PreviewCreateGameServerClusterResponse) XXX_Size() int {
	return xxx_messageInfo_PreviewCreateGameServerClusterResponse.Size(m)
}
func (m *PreviewCreateGameServerClusterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PreviewCreateGameServerClusterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PreviewCreateGameServerClusterResponse proto.InternalMessageInfo

func (m *PreviewCreateGameServerClusterResponse) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *PreviewCreateGameServerClusterResponse) GetTargetState() *TargetState {
	if m != nil {
		return m.TargetState
	}
	return nil
}

// Request message for GameServerClustersService.DeleteGameServerCluster.
type DeleteGameServerClusterRequest struct {
	// Required. The name of the Game Server Cluster to delete. Uses the form:
	// `projects/{project}/locations/{location}/gameServerClusters/{cluster}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteGameServerClusterRequest) Reset()         { *m = DeleteGameServerClusterRequest{} }
func (m *DeleteGameServerClusterRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteGameServerClusterRequest) ProtoMessage()    {}
func (*DeleteGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{6}
}

func (m *DeleteGameServerClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteGameServerClusterRequest.Unmarshal(m, b)
}
func (m *DeleteGameServerClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteGameServerClusterRequest.Marshal(b, m, deterministic)
}
func (m *DeleteGameServerClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteGameServerClusterRequest.Merge(m, src)
}
func (m *DeleteGameServerClusterRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteGameServerClusterRequest.Size(m)
}
func (m *DeleteGameServerClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteGameServerClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteGameServerClusterRequest proto.InternalMessageInfo

func (m *DeleteGameServerClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for GameServerClustersService.PreviewDeleteGameServerCluster.
type PreviewDeleteGameServerClusterRequest struct {
	// Required. The name of the Game Server Cluster to delete. Uses the form:
	// `projects/{project}/locations/{location}/gameServerClusters/{cluster}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The target timestamp to compute the preview.
	PreviewTime          *timestamp.Timestamp `protobuf:"bytes,2,opt,name=preview_time,json=previewTime,proto3" json:"preview_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PreviewDeleteGameServerClusterRequest) Reset()         { *m = PreviewDeleteGameServerClusterRequest{} }
func (m *PreviewDeleteGameServerClusterRequest) String() string { return proto.CompactTextString(m) }
func (*PreviewDeleteGameServerClusterRequest) ProtoMessage()    {}
func (*PreviewDeleteGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{7}
}

func (m *PreviewDeleteGameServerClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PreviewDeleteGameServerClusterRequest.Unmarshal(m, b)
}
func (m *PreviewDeleteGameServerClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PreviewDeleteGameServerClusterRequest.Marshal(b, m, deterministic)
}
func (m *PreviewDeleteGameServerClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreviewDeleteGameServerClusterRequest.Merge(m, src)
}
func (m *PreviewDeleteGameServerClusterRequest) XXX_Size() int {
	return xxx_messageInfo_PreviewDeleteGameServerClusterRequest.Size(m)
}
func (m *PreviewDeleteGameServerClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PreviewDeleteGameServerClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PreviewDeleteGameServerClusterRequest proto.InternalMessageInfo

func (m *PreviewDeleteGameServerClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PreviewDeleteGameServerClusterRequest) GetPreviewTime() *timestamp.Timestamp {
	if m != nil {
		return m.PreviewTime
	}
	return nil
}

// Response message for
// GameServerClustersService.PreviewDeleteGameServerCluster.
type PreviewDeleteGameServerClusterResponse struct {
	// The ETag of the game server cluster.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The target state.
	TargetState          *TargetState `protobuf:"bytes,3,opt,name=target_state,json=targetState,proto3" json:"target_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PreviewDeleteGameServerClusterResponse) Reset() {
	*m = PreviewDeleteGameServerClusterResponse{}
}
func (m *PreviewDeleteGameServerClusterResponse) String() string { return proto.CompactTextString(m) }
func (*PreviewDeleteGameServerClusterResponse) ProtoMessage()    {}
func (*PreviewDeleteGameServerClusterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{8}
}

func (m *PreviewDeleteGameServerClusterResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PreviewDeleteGameServerClusterResponse.Unmarshal(m, b)
}
func (m *PreviewDeleteGameServerClusterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PreviewDeleteGameServerClusterResponse.Marshal(b, m, deterministic)
}
func (m *PreviewDeleteGameServerClusterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreviewDeleteGameServerClusterResponse.Merge(m, src)
}
func (m *PreviewDeleteGameServerClusterResponse) XXX_Size() int {
	return xxx_messageInfo_PreviewDeleteGameServerClusterResponse.Size(m)
}
func (m *PreviewDeleteGameServerClusterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PreviewDeleteGameServerClusterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PreviewDeleteGameServerClusterResponse proto.InternalMessageInfo

func (m *PreviewDeleteGameServerClusterResponse) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *PreviewDeleteGameServerClusterResponse) GetTargetState() *TargetState {
	if m != nil {
		return m.TargetState
	}
	return nil
}

// Request message for GameServerClustersService.UpdateGameServerCluster.
type UpdateGameServerClusterRequest struct {
	// Required. The Game Server Cluster to be updated.
	// Only fields specified in update_mask are updated.
	GameServerCluster *GameServerCluster `protobuf:"bytes,1,opt,name=game_server_cluster,json=gameServerCluster,proto3" json:"game_server_cluster,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. For the `FieldMask` definition, see
	//
	// https:
	// //developers.google.com/protocol-buffers
	// // /docs/reference/google.protobuf#fieldmask
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateGameServerClusterRequest) Reset()         { *m = UpdateGameServerClusterRequest{} }
func (m *UpdateGameServerClusterRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateGameServerClusterRequest) ProtoMessage()    {}
func (*UpdateGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{9}
}

func (m *UpdateGameServerClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateGameServerClusterRequest.Unmarshal(m, b)
}
func (m *UpdateGameServerClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateGameServerClusterRequest.Marshal(b, m, deterministic)
}
func (m *UpdateGameServerClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateGameServerClusterRequest.Merge(m, src)
}
func (m *UpdateGameServerClusterRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateGameServerClusterRequest.Size(m)
}
func (m *UpdateGameServerClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateGameServerClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateGameServerClusterRequest proto.InternalMessageInfo

func (m *UpdateGameServerClusterRequest) GetGameServerCluster() *GameServerCluster {
	if m != nil {
		return m.GameServerCluster
	}
	return nil
}

func (m *UpdateGameServerClusterRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for GameServerClustersService.UpdateGameServerCluster.
type PreviewUpdateGameServerClusterRequest struct {
	// Required. The Game Server Cluster to be updated.
	// Only fields specified in update_mask are updated.
	GameServerCluster *GameServerCluster `protobuf:"bytes,1,opt,name=game_server_cluster,json=gameServerCluster,proto3" json:"game_server_cluster,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. For the `FieldMask` definition, see
	//
	// https:
	// //developers.google.com/protocol-buffers
	// // /docs/reference/google.protobuf#fieldmask
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The target timestamp to compute the preview.
	PreviewTime          *timestamp.Timestamp `protobuf:"bytes,3,opt,name=preview_time,json=previewTime,proto3" json:"preview_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PreviewUpdateGameServerClusterRequest) Reset()         { *m = PreviewUpdateGameServerClusterRequest{} }
func (m *PreviewUpdateGameServerClusterRequest) String() string { return proto.CompactTextString(m) }
func (*PreviewUpdateGameServerClusterRequest) ProtoMessage()    {}
func (*PreviewUpdateGameServerClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{10}
}

func (m *PreviewUpdateGameServerClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PreviewUpdateGameServerClusterRequest.Unmarshal(m, b)
}
func (m *PreviewUpdateGameServerClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PreviewUpdateGameServerClusterRequest.Marshal(b, m, deterministic)
}
func (m *PreviewUpdateGameServerClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreviewUpdateGameServerClusterRequest.Merge(m, src)
}
func (m *PreviewUpdateGameServerClusterRequest) XXX_Size() int {
	return xxx_messageInfo_PreviewUpdateGameServerClusterRequest.Size(m)
}
func (m *PreviewUpdateGameServerClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PreviewUpdateGameServerClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PreviewUpdateGameServerClusterRequest proto.InternalMessageInfo

func (m *PreviewUpdateGameServerClusterRequest) GetGameServerCluster() *GameServerCluster {
	if m != nil {
		return m.GameServerCluster
	}
	return nil
}

func (m *PreviewUpdateGameServerClusterRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *PreviewUpdateGameServerClusterRequest) GetPreviewTime() *timestamp.Timestamp {
	if m != nil {
		return m.PreviewTime
	}
	return nil
}

// Response message for GameServerClustersService.PreviewUpdateGameServerCluster
type PreviewUpdateGameServerClusterResponse struct {
	// The ETag of the game server cluster.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The target state.
	TargetState          *TargetState `protobuf:"bytes,3,opt,name=target_state,json=targetState,proto3" json:"target_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PreviewUpdateGameServerClusterResponse) Reset() {
	*m = PreviewUpdateGameServerClusterResponse{}
}
func (m *PreviewUpdateGameServerClusterResponse) String() string { return proto.CompactTextString(m) }
func (*PreviewUpdateGameServerClusterResponse) ProtoMessage()    {}
func (*PreviewUpdateGameServerClusterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{11}
}

func (m *PreviewUpdateGameServerClusterResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PreviewUpdateGameServerClusterResponse.Unmarshal(m, b)
}
func (m *PreviewUpdateGameServerClusterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PreviewUpdateGameServerClusterResponse.Marshal(b, m, deterministic)
}
func (m *PreviewUpdateGameServerClusterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PreviewUpdateGameServerClusterResponse.Merge(m, src)
}
func (m *PreviewUpdateGameServerClusterResponse) XXX_Size() int {
	return xxx_messageInfo_PreviewUpdateGameServerClusterResponse.Size(m)
}
func (m *PreviewUpdateGameServerClusterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PreviewUpdateGameServerClusterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PreviewUpdateGameServerClusterResponse proto.InternalMessageInfo

func (m *PreviewUpdateGameServerClusterResponse) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *PreviewUpdateGameServerClusterResponse) GetTargetState() *TargetState {
	if m != nil {
		return m.TargetState
	}
	return nil
}

// The Game Server Cluster connection information.
type GameServerClusterConnectionInfo struct {
	// The location of the Kubernetes cluster.
	//
	// Types that are valid to be assigned to ClusterReference:
	//	*GameServerClusterConnectionInfo_GkeClusterReference
	ClusterReference isGameServerClusterConnectionInfo_ClusterReference `protobuf_oneof:"cluster_reference"`
	// Namespace designated on the Game Server Cluster where the Agones game
	// server instances will be created. Existence of the namespace will be
	// validated during creation.
	Namespace            string   `protobuf:"bytes,5,opt,name=namespace,proto3" json:"namespace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GameServerClusterConnectionInfo) Reset()         { *m = GameServerClusterConnectionInfo{} }
func (m *GameServerClusterConnectionInfo) String() string { return proto.CompactTextString(m) }
func (*GameServerClusterConnectionInfo) ProtoMessage()    {}
func (*GameServerClusterConnectionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{12}
}

func (m *GameServerClusterConnectionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GameServerClusterConnectionInfo.Unmarshal(m, b)
}
func (m *GameServerClusterConnectionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GameServerClusterConnectionInfo.Marshal(b, m, deterministic)
}
func (m *GameServerClusterConnectionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GameServerClusterConnectionInfo.Merge(m, src)
}
func (m *GameServerClusterConnectionInfo) XXX_Size() int {
	return xxx_messageInfo_GameServerClusterConnectionInfo.Size(m)
}
func (m *GameServerClusterConnectionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_GameServerClusterConnectionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_GameServerClusterConnectionInfo proto.InternalMessageInfo

type isGameServerClusterConnectionInfo_ClusterReference interface {
	isGameServerClusterConnectionInfo_ClusterReference()
}

type GameServerClusterConnectionInfo_GkeClusterReference struct {
	GkeClusterReference *GkeClusterReference `protobuf:"bytes,7,opt,name=gke_cluster_reference,json=gkeClusterReference,proto3,oneof"`
}

func (*GameServerClusterConnectionInfo_GkeClusterReference) isGameServerClusterConnectionInfo_ClusterReference() {
}

func (m *GameServerClusterConnectionInfo) GetClusterReference() isGameServerClusterConnectionInfo_ClusterReference {
	if m != nil {
		return m.ClusterReference
	}
	return nil
}

func (m *GameServerClusterConnectionInfo) GetGkeClusterReference() *GkeClusterReference {
	if x, ok := m.GetClusterReference().(*GameServerClusterConnectionInfo_GkeClusterReference); ok {
		return x.GkeClusterReference
	}
	return nil
}

func (m *GameServerClusterConnectionInfo) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GameServerClusterConnectionInfo) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GameServerClusterConnectionInfo_GkeClusterReference)(nil),
	}
}

// A reference to a GKE cluster.
type GkeClusterReference struct {
	// The full or partial name of a GKE cluster, using one of the following
	// forms:
	//  * `projects/{project}/locations/{location}/clusters/{cluster}`
	//  * `locations/{location}/clusters/{cluster}`
	//  * `{cluster}`
	// If project and location are not specified, the project and location of the
	// GameServerCluster resource are used to generate the full name of the
	// GKE cluster.
	Cluster              string   `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GkeClusterReference) Reset()         { *m = GkeClusterReference{} }
func (m *GkeClusterReference) String() string { return proto.CompactTextString(m) }
func (*GkeClusterReference) ProtoMessage()    {}
func (*GkeClusterReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{13}
}

func (m *GkeClusterReference) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GkeClusterReference.Unmarshal(m, b)
}
func (m *GkeClusterReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GkeClusterReference.Marshal(b, m, deterministic)
}
func (m *GkeClusterReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GkeClusterReference.Merge(m, src)
}
func (m *GkeClusterReference) XXX_Size() int {
	return xxx_messageInfo_GkeClusterReference.Size(m)
}
func (m *GkeClusterReference) XXX_DiscardUnknown() {
	xxx_messageInfo_GkeClusterReference.DiscardUnknown(m)
}

var xxx_messageInfo_GkeClusterReference proto.InternalMessageInfo

func (m *GkeClusterReference) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

// A Game Server Cluster resource.
type GameServerCluster struct {
	// Required. The resource name of the Game Server Cluster. Uses the form:
	//
	// `projects/{project}/locations/{location}/realms/{realm}/gameServerClusters/{cluster}`.
	// For example,
	//
	// `projects/my-project/locations/{location}/realms/zanzibar/gameServerClusters/my-onprem-cluster`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last-modified time.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The labels associated with this Game Server Cluster. Each label is a
	// key-value pair.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Game Server Cluster connection information. This information is used to
	// manage Game Server Clusters.
	ConnectionInfo *GameServerClusterConnectionInfo `protobuf:"bytes,5,opt,name=connection_info,json=connectionInfo,proto3" json:"connection_info,omitempty"`
	// ETag of the resource.
	Etag string `protobuf:"bytes,6,opt,name=etag,proto3" json:"etag,omitempty"`
	// Human readable description of the cluster.
	Description          string   `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GameServerCluster) Reset()         { *m = GameServerCluster{} }
func (m *GameServerCluster) String() string { return proto.CompactTextString(m) }
func (*GameServerCluster) ProtoMessage()    {}
func (*GameServerCluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_38b9b9a78995689d, []int{14}
}

func (m *GameServerCluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GameServerCluster.Unmarshal(m, b)
}
func (m *GameServerCluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GameServerCluster.Marshal(b, m, deterministic)
}
func (m *GameServerCluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GameServerCluster.Merge(m, src)
}
func (m *GameServerCluster) XXX_Size() int {
	return xxx_messageInfo_GameServerCluster.Size(m)
}
func (m *GameServerCluster) XXX_DiscardUnknown() {
	xxx_messageInfo_GameServerCluster.DiscardUnknown(m)
}

var xxx_messageInfo_GameServerCluster proto.InternalMessageInfo

func (m *GameServerCluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GameServerCluster) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *GameServerCluster) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *GameServerCluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *GameServerCluster) GetConnectionInfo() *GameServerClusterConnectionInfo {
	if m != nil {
		return m.ConnectionInfo
	}
	return nil
}

func (m *GameServerCluster) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *GameServerCluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func init() {
	proto.RegisterType((*ListGameServerClustersRequest)(nil), "google.cloud.gaming.v1beta.ListGameServerClustersRequest")
	proto.RegisterType((*ListGameServerClustersResponse)(nil), "google.cloud.gaming.v1beta.ListGameServerClustersResponse")
	proto.RegisterType((*GetGameServerClusterRequest)(nil), "google.cloud.gaming.v1beta.GetGameServerClusterRequest")
	proto.RegisterType((*CreateGameServerClusterRequest)(nil), "google.cloud.gaming.v1beta.CreateGameServerClusterRequest")
	proto.RegisterType((*PreviewCreateGameServerClusterRequest)(nil), "google.cloud.gaming.v1beta.PreviewCreateGameServerClusterRequest")
	proto.RegisterType((*PreviewCreateGameServerClusterResponse)(nil), "google.cloud.gaming.v1beta.PreviewCreateGameServerClusterResponse")
	proto.RegisterType((*DeleteGameServerClusterRequest)(nil), "google.cloud.gaming.v1beta.DeleteGameServerClusterRequest")
	proto.RegisterType((*PreviewDeleteGameServerClusterRequest)(nil), "google.cloud.gaming.v1beta.PreviewDeleteGameServerClusterRequest")
	proto.RegisterType((*PreviewDeleteGameServerClusterResponse)(nil), "google.cloud.gaming.v1beta.PreviewDeleteGameServerClusterResponse")
	proto.RegisterType((*UpdateGameServerClusterRequest)(nil), "google.cloud.gaming.v1beta.UpdateGameServerClusterRequest")
	proto.RegisterType((*PreviewUpdateGameServerClusterRequest)(nil), "google.cloud.gaming.v1beta.PreviewUpdateGameServerClusterRequest")
	proto.RegisterType((*PreviewUpdateGameServerClusterResponse)(nil), "google.cloud.gaming.v1beta.PreviewUpdateGameServerClusterResponse")
	proto.RegisterType((*GameServerClusterConnectionInfo)(nil), "google.cloud.gaming.v1beta.GameServerClusterConnectionInfo")
	proto.RegisterType((*GkeClusterReference)(nil), "google.cloud.gaming.v1beta.GkeClusterReference")
	proto.RegisterType((*GameServerCluster)(nil), "google.cloud.gaming.v1beta.GameServerCluster")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.gaming.v1beta.GameServerCluster.LabelsEntry")
}

func init() {
	proto.RegisterFile("google/cloud/gaming/v1beta/game_server_clusters.proto", fileDescriptor_38b9b9a78995689d)
}

var fileDescriptor_38b9b9a78995689d = []byte{
	// 992 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x57, 0xbd, 0x73, 0x1b, 0x45,
	0x14, 0xe7, 0x24, 0x7f, 0x44, 0xef, 0x02, 0xc1, 0xeb, 0x00, 0x42, 0x09, 0xb2, 0xe6, 0x66, 0x48,
	0xdc, 0xe4, 0x6e, 0x30, 0x93, 0x99, 0x7c, 0x34, 0xb6, 0x0c, 0x04, 0x33, 0xc9, 0x8c, 0x39, 0x9b,
	0x86, 0xe6, 0x66, 0x75, 0x7a, 0x3a, 0x1f, 0xba, 0xdb, 0x3d, 0x76, 0x57, 0x02, 0xc7, 0xe3, 0x8e,
	0x22, 0x0d, 0x05, 0xff, 0x0c, 0x0d, 0x3d, 0x0d, 0xff, 0x00, 0x65, 0x1a, 0x1a, 0x3a, 0x5a, 0x2a,
	0xe6, 0xf6, 0x56, 0x1f, 0xe6, 0x24, 0x81, 0x26, 0x1e, 0x17, 0x0c, 0x95, 0x76, 0xdf, 0xbe, 0x8f,
	0x7d, 0xef, 0xf7, 0x7b, 0xef, 0x56, 0x70, 0x3f, 0xe2, 0x3c, 0x4a, 0xd0, 0x0b, 0x13, 0x3e, 0xe8,
	0x7a, 0x11, 0x4d, 0x63, 0x16, 0x79, 0xc3, 0x0f, 0x3a, 0xa8, 0x68, 0xbe, 0xc3, 0x40, 0xa2, 0x18,
	0xa2, 0x08, 0xc2, 0x64, 0x20, 0x15, 0x0a, 0xe9, 0x66, 0x82, 0x2b, 0x4e, 0x1a, 0x85, 0x99, 0xab,
	0xcd, 0xdc, 0xc2, 0xcc, 0x2d, 0xcc, 0x1a, 0x5b, 0xc6, 0x25, 0xcd, 0x62, 0xaf, 0x17, 0x63, 0xd2,
	0x0d, 0x3a, 0x78, 0x42, 0x87, 0x31, 0x17, 0x85, 0x71, 0xe3, 0xdd, 0x29, 0x05, 0x81, 0x92, 0x0f,
	0x44, 0x88, 0xe6, 0xe8, 0xee, 0x82, 0xeb, 0x84, 0x3c, 0x4d, 0x39, 0x33, 0x8a, 0x2d, 0xa3, 0xa8,
	0x77, 0x9d, 0x41, 0xcf, 0x44, 0x4a, 0xa9, 0xec, 0x1b, 0x8d, 0xad, 0xbf, 0x6b, 0xa8, 0x38, 0x45,
	0xa9, 0x68, 0x9a, 0x19, 0x85, 0xdb, 0x53, 0xd7, 0xa0, 0x8c, 0x71, 0x45, 0x55, 0xcc, 0x99, 0xc9,
	0xd0, 0xf9, 0xc3, 0x82, 0xf7, 0x9e, 0xc6, 0x52, 0x3d, 0xa1, 0x29, 0x1e, 0xe9, 0x1a, 0xec, 0x9b,
	0x12, 0xf8, 0xf8, 0xf5, 0x00, 0xa5, 0x22, 0xcf, 0x60, 0x2d, 0xa3, 0x02, 0x99, 0xaa, 0x5b, 0x2d,
	0x6b, 0xbb, 0xd6, 0xbe, 0xff, 0x72, 0xaf, 0xf2, 0xe7, 0x9e, 0x47, 0xee, 0xe5, 0x75, 0xcb, 0xcb,
	0x16, 0x87, 0x28, 0xdd, 0x22, 0x08, 0xcd, 0x62, 0xe9, 0x86, 0x3c, 0xf5, 0x4a, 0xee, 0x7c, 0xe3,
	0x84, 0xb4, 0xa0, 0x96, 0xd1, 0x08, 0x03, 0x19, 0x3f, 0xc7, 0x7a, 0xa5, 0x65, 0x6d, 0xaf, 0xb6,
	0xab, 0x2f, 0xf7, 0x2c, 0xff, 0x5a, 0x2e, 0x3d, 0x8a, 0x9f, 0x23, 0x71, 0x00, 0xb4, 0x86, 0xe2,
	0x7d, 0x64, 0xf5, 0xaa, 0x0e, 0xaa, 0x55, 0xb4, 0xe1, 0x71, 0x2e, 0x25, 0xb7, 0x60, 0xad, 0x17,
	0x27, 0x0a, 0x45, 0x7d, 0x65, 0x72, 0x6e, 0x44, 0xa4, 0x09, 0xd7, 0xb8, 0xe8, 0xa2, 0x08, 0x3a,
	0xa7, 0xf5, 0xd5, 0xc9, 0xf1, 0xba, 0x16, 0xb6, 0x4f, 0x9d, 0x5f, 0x2c, 0x68, 0xce, 0xcb, 0x59,
	0x66, 0x9c, 0x49, 0x24, 0x01, 0xdc, 0x9c, 0x45, 0x8b, 0xba, 0xd5, 0xaa, 0x6e, 0xdb, 0x3b, 0xf7,
	0xdc, 0xf9, 0xbc, 0x70, 0xcb, 0xa9, 0x93, 0xa8, 0x14, 0x88, 0xdc, 0x81, 0x1b, 0x0c, 0xbf, 0x55,
	0xc1, 0x54, 0xa6, 0x79, 0x31, 0x6a, 0xfe, 0xeb, 0xb9, 0xf8, 0x70, 0x9c, 0x68, 0x0b, 0xec, 0x01,
	0x13, 0x48, 0xc3, 0x13, 0xda, 0x49, 0xb0, 0xbe, 0xd2, 0xaa, 0x6e, 0xd7, 0xfc, 0x69, 0x91, 0x73,
	0x02, 0xb7, 0x9e, 0x60, 0x39, 0x97, 0x11, 0x7c, 0x07, 0xb0, 0xc2, 0x68, 0x8a, 0x17, 0xc1, 0x83,
	0x25, 0xc1, 0xd3, 0x2e, 0x9c, 0xef, 0x2b, 0xd0, 0xdc, 0x17, 0x48, 0x15, 0xce, 0x8d, 0x76, 0xc9,
	0x64, 0x79, 0x00, 0x6f, 0xcf, 0x80, 0x21, 0x88, 0xbb, 0x45, 0xb1, 0x72, 0x5c, 0x2b, 0xfe, 0x66,
	0xa9, 0xbc, 0x07, 0x5d, 0xd2, 0x81, 0xcd, 0x19, 0x96, 0x9a, 0x4d, 0xcb, 0xe2, 0x57, 0x44, 0xd9,
	0x28, 0x45, 0x71, 0x7e, 0xad, 0xc0, 0xfb, 0x87, 0x02, 0x87, 0x31, 0x7e, 0xf3, 0x7f, 0x59, 0xc6,
	0x72, 0xd2, 0x86, 0xeb, 0x59, 0x51, 0x95, 0x20, 0x9f, 0x45, 0xba, 0x43, 0xed, 0x9d, 0xc6, 0xc8,
	0xf9, 0x68, 0x50, 0xb9, 0xc7, 0xa3, 0x41, 0x55, 0xb4, 0xa7, 0x6d, 0x8c, 0x72, 0xb1, 0xf3, 0xc2,
	0x82, 0x3b, 0xff, 0x54, 0x5a, 0xd3, 0xaa, 0x04, 0x56, 0x50, 0xd1, 0xc8, 0xb4, 0x8f, 0x5e, 0x93,
	0xcf, 0xe0, 0xba, 0xa2, 0x22, 0x42, 0x15, 0x48, 0x45, 0x15, 0x9a, 0xfc, 0xee, 0x2e, 0xca, 0xef,
	0x58, 0xeb, 0x1f, 0xe5, 0xea, 0xbe, 0xad, 0x26, 0x1b, 0xa7, 0x0f, 0xcd, 0x8f, 0x30, 0xc1, 0x05,
	0xe8, 0x5e, 0x62, 0x8b, 0xfd, 0x68, 0x8d, 0x29, 0x75, 0x65, 0x41, 0x4b, 0x80, 0x55, 0x5e, 0x0d,
	0xb0, 0xb9, 0x17, 0xbf, 0x22, 0xc0, 0x7e, 0xb6, 0xa0, 0xf9, 0x45, 0xd6, 0x5d, 0xd4, 0x8f, 0x73,
	0xda, 0xc0, 0xba, 0xcc, 0x36, 0xd8, 0x05, 0x7b, 0xa0, 0x6f, 0xa1, 0xbf, 0xd6, 0x73, 0x8b, 0xfa,
	0x49, 0xfe, 0x41, 0x7f, 0x46, 0x65, 0xbf, 0x70, 0x04, 0x85, 0x4d, 0x2e, 0x70, 0x7e, 0x98, 0xcc,
	0x97, 0xff, 0x42, 0x3e, 0x25, 0x9e, 0x55, 0x5f, 0x8d, 0x67, 0x73, 0x6b, 0x72, 0x45, 0x3c, 0xfb,
	0xc9, 0x82, 0xad, 0x52, 0xf4, 0x7d, 0xce, 0x18, 0x86, 0xf9, 0x0b, 0xeb, 0x80, 0xf5, 0x38, 0x41,
	0x78, 0x2b, 0xea, 0xe3, 0x78, 0x42, 0x0b, 0xec, 0xa1, 0x40, 0x16, 0x62, 0x7d, 0x5d, 0x07, 0xf6,
	0x16, 0x42, 0xd3, 0xc7, 0x71, 0x4a, 0xc6, 0xec, 0xd3, 0xd7, 0xfc, 0xcd, 0xa8, 0x2c, 0x26, 0xb7,
	0xa1, 0x96, 0x77, 0xb2, 0xcc, 0x68, 0x88, 0xc5, 0x93, 0xc7, 0x9f, 0x08, 0xda, 0x9b, 0xb0, 0x51,
	0xba, 0x80, 0xe3, 0xc1, 0xe6, 0x8c, 0x00, 0xa4, 0x0e, 0xeb, 0xd3, 0xec, 0xa9, 0xf9, 0xa3, 0xad,
	0xf3, 0xdb, 0x0a, 0x6c, 0x94, 0xd2, 0x25, 0xef, 0x5c, 0x18, 0x43, 0x1a, 0xf2, 0x62, 0xa8, 0xec,
	0x82, 0x1d, 0xea, 0xc9, 0xbd, 0xc4, 0x4c, 0xa9, 0xfa, 0x50, 0xd8, 0xe4, 0xd2, 0x29, 0xc2, 0xfd,
	0x7b, 0xb6, 0x54, 0x47, 0x84, 0xd3, 0x1e, 0x3e, 0x87, 0xb5, 0x84, 0x76, 0x30, 0x91, 0xfa, 0xdd,
	0x64, 0xef, 0x3c, 0x5c, 0xaa, 0x13, 0xdc, 0xa7, 0xda, 0xf6, 0x63, 0xa6, 0xc4, 0xa9, 0x6f, 0x1c,
	0x91, 0x2e, 0xdc, 0x08, 0xc7, 0x10, 0x07, 0x31, 0xeb, 0x71, 0x5d, 0x6f, 0x7b, 0xe7, 0xf1, 0x52,
	0xbe, 0x2f, 0xd2, 0xc4, 0x7f, 0x23, 0xbc, 0x48, 0x9b, 0x11, 0x75, 0xd7, 0xa6, 0xa8, 0xdb, 0x02,
	0xbb, 0x8b, 0x32, 0x14, 0x71, 0x96, 0xab, 0x69, 0x02, 0xd5, 0xfc, 0x69, 0x51, 0xe3, 0x21, 0xd8,
	0x53, 0x57, 0x26, 0x6f, 0x42, 0xb5, 0x8f, 0xa7, 0x06, 0xc6, 0x7c, 0x49, 0x6e, 0xc2, 0xea, 0x90,
	0x26, 0x03, 0x34, 0x2d, 0x51, 0x6c, 0x1e, 0x55, 0x1e, 0x58, 0x8f, 0x5e, 0x58, 0xbf, 0xef, 0x7d,
	0x67, 0x2d, 0xf9, 0xf9, 0x20, 0x47, 0x99, 0xe0, 0x5f, 0x61, 0xa8, 0xa4, 0x77, 0x66, 0x56, 0xe7,
	0x5e, 0xc2, 0xc3, 0xe2, 0x0f, 0x86, 0x77, 0x36, 0x5a, 0x9e, 0x7b, 0x02, 0x69, 0x92, 0x4a, 0xef,
	0x4c, 0xff, 0x9e, 0x7b, 0xe5, 0xf7, 0xb0, 0x77, 0x66, 0x68, 0x76, 0xde, 0xee, 0x42, 0x33, 0xe4,
	0xe9, 0x82, 0x6a, 0x1e, 0x5a, 0x5f, 0xee, 0x9a, 0xd3, 0x88, 0x27, 0x94, 0x45, 0x2e, 0x17, 0x91,
	0x17, 0x21, 0xd3, 0x94, 0xf0, 0x26, 0xb7, 0x9e, 0xf5, 0xf7, 0xea, 0x71, 0xb1, 0xeb, 0xac, 0x69,
	0xe5, 0x0f, 0xff, 0x0a, 0x00, 0x00, 0xff, 0xff, 0x58, 0xa6, 0xa8, 0x8a, 0x19, 0x0e, 0x00, 0x00,
}
