package constants

const (
	Audio = iota
	Bluetooth
	Build
	Camera
	Clock
	Contacts
	EMail
	MusicApp
	Networking
	NFC
	SEPolicy
	Settings
	SurfaceFlinger
	SystemUI
	Telephony
	Unknown
	Video
	Vold
	WiFi
)

var TechAreaDisplay = map[uint8]string{
	Audio:          "Audio",
	Bluetooth:      "Bluetooth",
	Build:          "Build",
	Camera:         "Camera",
	Clock:          "Clock",
	Contacts:       "Contacts",
	EMail:          "EMail",
	MusicApp:       "MusicApp",
	Networking:     "Networking",
	NFC:            "NFC",
	SEPolicy:       "SEPolicy",
	Settings:       "Settings",
	SurfaceFlinger: "SurfaceFlinger",
	SystemUI:       "SystemUI",
	Telephony:      "Telephony",
	Unknown:        "Unknown",
	Video:          "Video",
	Vold:           "Vold",
	WiFi:           "WiFi",
}

// A corresponding tool exists in tools/tech_area_csv_to_hashes.py that will convert a CSV of email addresses into hashes that can be added here;
// The intent is to prevent PII from arriving into the codebase itself.
var AuthorHashToTechIndex = map[string]uint8{
	"295009c9ca8962fedc4f107dc975ee9f3fcee84892b7319e9117484f368c355f": Bluetooth,
	"80f2eb0c7893b05611ae4f365db71a1a8648464ce8ff3afc589d5bdf5b8c92ca": Audio,
	"418dabcacfb241f57d2c64f77e902003e48444b8b4146ad35057e15f0125bb7a": Bluetooth,
	"3a8862f55db078b5e15eb479b3ea5d765c8187336632d05cfa2e045f763f52f5": SurfaceFlinger,
	"7574a55e444591c22cb4972a164e89df06dcfe7b6fe8533e1a4277ab0e7f3235": Audio,
	"93d05fb208c849f1c78738c45db9f39a6f7d97d899aa1371503fc3ca467ee267": Audio,
	"d12c08ffff9c1476df23f18223ad99d3784c2b610919415042e25729fb36210e": Vold,
	"1066d00f8b59cb22ea4eceb719f3081e0257ae0afafd914ca8daa57b3b5e5657": Telephony,
	"65d642180750d2d85a45c90244c5964c4b7f3d441124ebd2a6b2bf307b11ad23": Bluetooth,
	"a2ca3501551e29012b4210fc8e2987489c0e21a2dec3da289b8fe85179683819": Telephony,
	"14a3ed379da733ce7aa50a05f8bb3c553fd8e735b242571807c7627064705b1c": Audio,
	"0366825feb4bcd6533e197a305d1e660f95e3b15ca4bf501b42bcd7bd404c857": WiFi,
	"ab482fae9619f1370a6f03f89554a7c5e0fa346abb6df3bcddbf3bb3bce35967": Audio,
	"37b825f94ae1c36a3071f21b1c4162f31721cdde5e94aa47821cb55899897b70": SEPolicy,
	"bed383c5bed9017de63cb0e8d56833840306f81215aeddd51e90243da89d172c": Contacts,
	"e5fdb4c697747701e190c6aedd0c92f6f2847f5af6916863884cfeef4e622d11": Telephony,
	"49d23c434b94f5818bec9a3bd1a90c7cda5f3f950dbd652c3229bf54b4da0586": Bluetooth,
	"05ff4831bad2f9e09ac5cfa2b6ccd590d039b5d5d54dbbe771932ab3d72de1b8": Telephony,
	"06e1c2e8bc7ee230b3819e8221ed935b0413b29b82a164280ab3d626c502b75e": Clock,
	"dd5e3c67aa977d8f00f4af5a098686b87e95098a2ac4395c88c5261cc5a1b86e": Bluetooth,
	"f2eae6b8064c61593ab1514875c3d19f75b0b34010d62add79e112298208d867": Telephony,
	"3ddcafa98e497d33f647e3189d09d9e28e27dd6c733fc4e93c7fc2fa38b7210d": WiFi,
	"3a00596a2d13ddf319a911f3caada92470270b54d966d846948f55eab4c69348": SurfaceFlinger,
	"681a62d4883a953d47333632dd2d7214660e60479311bc11747e38535e98083f": Networking,
	"2f64a0ee617b1e58a7e35e546c435e59053c3bb83bae7d8e780e4b23dc764b0e": Telephony,
	"573e264d482b1e638bbc6bd7013eb24d9c299159657be24ec0d88f00506f63ec": Telephony,
	"70f281df3ec7cbe629efec8dc4e7d4546a3a0cdd0d6ac186e7f3cc0c7649b0e1": Audio,
	"5670faeb58b20718de2d2dfc72b52a6000ce30e8eb3e46fb5fccb39b1410d35c": Settings,
	"bc513167cf009ce176ed0e6438f99cfb054e3d3f3ff9847fc565e22580137a21": WiFi,
	"331f7939ce64e48ed6824870cb279e241669a756bc8388611c6dda8c4c712250": SurfaceFlinger,
	"662927ab0d7dfbbf155b83d4fe641ae3e201c65a0754d3042086333c34eeb790": Build,
	"9cc26dcbd039de295d4ed50393cd83ff28aab76dce5b638390d2f296e4e91e2a": Networking,
	"42292e3359a7fdec2aee650671c0ca98576a00ce21fef71a31932277ecbba9a3": Camera,
	"44096f7016b2bcad994d60fb8596da45a29e33833f21b0134b1ca74d39cd93c8": Telephony,
	"60b92ba6920c64260c3b6aed35152fca501c84e04d9493db7dc76dba3d6f91c0": Bluetooth,
	"48f9fb882dc5a16d46c9ef0dc82b73c1031466a60ca0ed366190a8cad144cda1": Settings,
	"59ce95fe057821fd1a45391efe07685be3f6271f0e573d75980c6fc900669744": Telephony,
	"f19c0c201ecff09c06d90d0de52bcf95d162dc42bb8961944cfa544b20bc2b88": Bluetooth,
	"2e72709bdf008b369491799a2c6d32f53d74a189e1efd72c7d826501bcd7300e": Telephony,
	"5b696ac14df15078e01dae62ab335615c06c6310f29a6b522fd2f01690240de5": Networking,
	"33c0e43331931ca03c73fcb9cb87c9e10d488adb4db040e2b6c9e13f2a717c0c": Video,
	"5cd2466a14aae7d9633116e0566ff0ce1d322d0862891f3ad773e6ad54bd93c0": Networking,
	"eeb41e6a333a62d748e02e2e047da2d063fc7c457624128ce17d7d90d4f167cf": Settings,
	"a82865530a0f77effafb99f073580847adf7436d50b3d9a93ff351e9e2c305ca": Bluetooth,
	"2490f5f20143c9ce192611bfaded68353a63d960a449bdd12e64e064bb24c089": Camera,
	"0a7b61d9c1858a5dfc86043e2823a7914f5357724d8fc0ccf8cdfe72c1b16a68": Video,
	"f4f1f859b76d8ed741c82e113f86fcd2e26bdc9355200adea12a64d366b180c8": Bluetooth,
	"42ab1752beb0dbd8bd1c0696ac849659ad939f268fa6c6d7cbfb97c28fac06cf": Telephony,
	"bd50758bec0050a59bf1ca3389f65e15a7739651dfee4d8885a7cedcb202cb8a": Networking,
	"e3bcdc063695ed7990fa633ea52b296cb855b31cd100ccf630b9d76f0bfea132": Settings,
	"2d85611c4fddec1cf00f60a347ce89cd0a4c5deb05f3ad86506ab62f32d7f8ff": EMail,
	"419479b224f1ba7f805e6db2dba822c07a396befa8d76f2782bd145e90d9847f": WiFi,
	"2a98451d0f489566c589e3fb9435c58f6f2af1068675ca87f1729c1a6be5c2c2": Telephony,
	"cbdce6d737d377f0902ad66b0bc6c5a968679fa9b1210dd55ca28cbc131009d8": Video,
	"ec61d215885ffc26d444adc92f949cceb5a932fb10804045467b70389352f2be": Bluetooth,
	"17ff40b14e82c9e8f166643fc71fdca5ae15eaf22ecc56c2098b1f6d480539f0": Telephony,
	"773773fd33db781b6692ee02e5ea65a4a25801fa95ef038e754fd050160e1733": SystemUI,
	"79b48908c75fe30c8163d36afa45817248d08cc9d86f83bae466059b3329366f": Telephony,
	"3d5ae61cf8da2b85e49a9b5446531c42a32ef54a91c25986d2ed34ac5f6dd50b": Bluetooth,
	"9495abc218bdb8df701c3f8ae94454794dbce92fece355f6c8760ad202790f46": Networking,
	"1c50b6e6cdb50e45839285e292be8ae9d0ede8a4ee121f693b1ec8de9731f3ad": Telephony,
	"ca87331b9184b199897d79289a4b51a8fcc0f0201e263252ea0bb274d3086bf0": Bluetooth,
	"9ff8f67da7f2c37879e94d7cd7d51b9e62cda129d4e43326c9b9229ed00e7032": Audio,
	"9a7f2765a97de27c4f426f1d8c13f2eca57b81f694c47a4b4d65b92f5a32de56": Networking,
	"5af9d69ce6a75bf41e5f3cbaebcee0cd77a180d054ccf5713cc7ce563b9e5c3f": Bluetooth,
	"7abb15f91bf2b316a5167ade04bd8575acf6b0e66704f2a2e521fa3b0a2d83a8": Telephony,
	"3c609c76c2d40920238cf26bd8a789f96fdde230dbb1e48cfda7442346296bdf": SurfaceFlinger,
	"29b9c3f8dba18233c26fae628736b95d3b53540238629525d141dde90f6fac66": WiFi,
	"c8ce03263d945bf808f013c5f8a25116d41242d9f6dbb9378eb398be5f00955e": Video,
	"cfb3a1bfc83adbfea42d0499b0dd8a281542c9f5de1e11a67d2f1ef0f3c7dcdb": Telephony,
	"b157ca758ddaa4362c9a84f1f977540fe939d225f470dbacc77b4ad44ea1f29a": WiFi,
	"9c115a8d3177d16b880bb7bada328d998d1b2a4e8a8e29b7438fa8d700f34583": Bluetooth,
	"4e1d54f69c2ee87644c52b58de639ace9dc57557825ced0c22fe67df788073ca": Telephony,
	"2a6c726d42ddb4d745173e9b4caf30ff9a6b5a5a8e42de793bc8ba898a0a0200": NFC,
	"a974d8ab9346e4d82d6a567c7bd35bb2f5312978ed89c927b09c626215691d2b": Build,
	"eebf06f40beb55a8e82559397ae370e3a45f25a80c75936eb235b904c3b89cba": Contacts,
	"604f0e9f1b0f878c0e974f41896808ca45ef5df27dff96c47e81c18341aebcfc": Bluetooth,
	"ace92388eba2ab55237546407c574a71057f0dff9a639f36ead324384cc8982f": Telephony,
	"b8cd36ac791ab7113434c9d4399355eab035726ce78477456c730766c6ff4735": Bluetooth,
	"f65cef249ceb32fe7e8d746458faf273060f207df50df8c09b3d590402ac7ff3": Telephony,
	"6fd4cbfe82baa9427ecf99a55623be046e98aef8fd24a63e5a9657b83ae8e38a": Telephony,
	"a0969128fcfa6ae1c8c7747b154efb434b21b49c3d9ddac75bae3ad99f856947": WiFi,
	"15d72bf3d3cba8ccb52b8c0edf28984921730bea61e2ba1292255eef1bce21ee": Telephony,
	"0ee1c59eebf5fd6212e56ebb34621eb1c0d234c475b40afb364174245485fc20": Camera,
	"05f66ed7fbf8ead8f44b3d69642ec86c6bfabcf43d4ffdd1502f90ce57b61c16": Telephony,
	"314c841d08601f3211c8738c76a13f08a9d78f0bf347e57ac56059e02e10ab4e": Audio,
	"6c17cc17bfd5387493de86c8b340ecfa042d4648c0c482f52e4400ca6f54a35c": Camera,
	"2a60b8ddc1ebe17d7725f74e493f3f060175d3e24558f1a7b828f558e1ec1d26": MusicApp,
	"816ec9143c739b50f06ae223d4b3ed6245dd2d6d42cddf3d7631cb54e8338493": Telephony,
	"cdde6fcfa79c438454043ef519046f03ad5f29813890c8edf3686bf8d3c794fd": Camera,
	"b4073a9374704b81e44462235f1ae4b034d965efa34f38e3a04ec17e8e22b903": Telephony,
	"635d4d83e1cc9ab8270b8446393842933c70e7afaf57f828399944e93d110036": Bluetooth,
	"19840f147cff739f67204e3dad4265727a5a3bfb192a97e805a7906040151820": Telephony,
	"6fb1e20b34dc1f603cb8caadcd9c7b5d0050212f975e19379872ba8df33b151f": Telephony,
	"fe183c67ea8838d4eca79db3b18f49b3681d1997ac328940119799a132ea343f": Bluetooth,
	"28021a9efc0ea04c3d4c8d80b71c8c82fbd7add2b4501ccdc25c081fc9f7e352": Telephony,
	"a006d5cc780600583fd83e1306082bf89e25f1befe87f8c5a6f5681c1f93ddcf": Telephony,
	"390d577f6cd565b51497e3ca72caa49eb9d9941e04a41ec8c07eb75b22a6d6d6": Bluetooth,
	"84c07a2d8becb6e5f9b62d739c56f6b9814b9d59b1117db2338d33a9c98d66ef": Bluetooth,
	"48bfccfd99166a176b67d74f3eda25f8c638ba8d5b6eecd34d30d00ea9cf3105": WiFi,
	"2a63c8bd49a76f03e7fa861d2228c75be6ee0868a251657877345ffe444ae417": Bluetooth,
	"a368d3b73c29a18cbc7a32c0d4a417a6791a029cf1cf97e3b75ab6817bfb1019": Camera,
	"c41aedef1a8a49a8b8069500a32c65ce21add5c0e554d5f1bfa0662678219418": Telephony,
	"693f2d57a20ffc66a6b98f4788d273b8aa38b9b264ed2fd752ead27b07202c6a": Bluetooth,
	"d599b774477f09e778ccc8ccdc0d090b446ec783328d66ca4aa473ad416796c9": Vold,
	"d5da2110b79a8d4dcf0329fd092dd4071076472b9b9178b844f8775ffedf6ac9": Bluetooth,
	"0322c0f7aba62a0fd00c30faaed186e92d414ed7b468a6bb24a6278764e4fa1d": Telephony,
	"94500ea08fae56e8d4804a1f0ec432ec571b9ca0326609047c47eabf3fb19f95": MusicApp,
	"326e042d57a5451c3067e36b909feb36fe266ed36ad1ed7b516f274632ce996e": Networking,
	"e065aab9750134f1de64479959e02ad03732f912f64b3ee479d50b4031bd84ae": Build,
	"241dd2d8cf8fe95291507c7a2cc10cb3fbfc55e39b59f4326cb8f01573723a73": Camera,
	"b132fd4d8f4b9cf1f34942997412f9b729f0df18485e38ddc98c35fa59b6836c": Telephony,
	"50bc979e37d96b3144a23f2291348e877e77a534a9dbd5d460a22698f1634f6e": Bluetooth,
	"cb2b9ad6eedaccb5a902fc8e0ca236013c6da55936d52a1d14c5aa501e60888c": Bluetooth,
	"6ca8406cebd3793383de4693d65bee7f2b7c78cd735add872e291bf34b4b56e9": Telephony,
	"6dcef833d0cf6e38519e75e9c1d90e5c0e827568cd421ed10deb0bb7bcf2341c": Bluetooth,
	"787d3bda5e24da8d5f2d1420341f206199016a031b00aa56858660598f45b63c": Camera,
	"79ad2afaaae88dee456b7d2ab3acea34cd756b89251529e666b4647bdbf8b965": Settings,
	"9d4cf697a6f68fa811c4d4d43e76f7ce21f0e62bd19a8ce1ad9bda1e17a9f022": Telephony,
	"f926c0d0933248aa66ed7b4dfd0ba86ee5a75124279cb922eae5846e92c7138a": Telephony,
	"504fa258405c4fa386efa376412c55e3988968ccfc700316b83719d42e371418": EMail,
	"b67f7f4bdeff3d47f4bb9ec8408c5c06bf90a869a51bcfc74ce163213365ecb6": Telephony,
	"e3c49447c3d3caa8524d4a847f47b77aedf85253155736aeca9e3513bc0135f0": Telephony,
	"4d30fb2606f6c2ef3c6a4dea92ca3cdd01fc43d615bd2940d8b5d3f80d425d1b": Audio,
	"fa217b2b0ff9714a35698aa2dec91ee1163c8a17f86f731fa1caf3fe4572b8e5": Telephony,
	"c897dc68a083deaf72a69d8f42b3df351a05dc15ace23edc6cf6fb83f580acaf": Video,
	"de4e86df4febc64d99a1abff50b7f67faedd366bc6a6e2860d17e8d306ecb487": Telephony,
	"9b42f4c090530ba44b6af33bc5c0175d401526aca797f69cf23d51e933918337": Telephony,
	"518cad57ef2c7425d65f80f21bbcda676ae8962da823ba4953698c401ead2ad7": Build,
	"5ad23d39598d2536d063cd955b5605c55d794ff5d29752699f48112aeccbeef1": Build,
}
