









use core::hint::spin_loop;
use core::sync::atomic::{AtomicBool, Ordering};
use std::thread;
use std::time::Instant;


pub struct ThreadParker {
    parked: AtomicBool,
}

impl super::ThreadParkerT for ThreadParker {
    type UnparkHandle = UnparkHandle;

    const IS_CHEAP_TO_CONSTRUCT: bool = true;

    #[inline]
    fn new() -> ThreadParker {
        ThreadParker {
            parked: AtomicBool::new(false),
        }
    }

    #[inline]
    unsafe fn prepare_park(&self) {
        self.parked.store(true, Ordering::Relaxed);
    }

    #[inline]
    unsafe fn timed_out(&self) -> bool {
        self.parked.load(Ordering::Relaxed) != false
    }

    #[inline]
    unsafe fn park(&self) {
        while self.parked.load(Ordering::Acquire) != false {
            spin_loop();
        }
    }

    #[inline]
    unsafe fn park_until(&self, timeout: Instant) -> bool {
        while self.parked.load(Ordering::Acquire) != false {
            if Instant::now() >= timeout {
                return false;
            }
            spin_loop();
        }
        true
    }

    #[inline]
    unsafe fn unpark_lock(&self) -> UnparkHandle {
        
        self.parked.store(false, Ordering::Release);
        UnparkHandle(())
    }
}

pub struct UnparkHandle(());

impl super::UnparkHandleT for UnparkHandle {
    #[inline]
    unsafe fn unpark(self) {}
}

#[inline]
pub fn thread_yield() {
    thread::yield_now();
}
