







//! # fn main() -> Result<(), Box<dyn std::error::Error>> {



//! #[derive(serde::Serialize, serde::Deserialize, Debug)]
//! #[serde(transparent)]

//!     #[serde(with = "either::serde_untagged_optional")]








//! assert_eq!(serde_json::to_string(&data)?, r#"["Hello"]"#);



//!     r#"{"a": 0, "b": 14}"#


//! # Ok(())
//! # }


use serde::{Deserialize, Deserializer, Serialize, Serializer};

#[derive(Serialize, Deserialize)]
#[serde(untagged)]
enum Either<L, R> {
    Left(L),
    Right(R),
}

pub fn serialize<L, R, S>(
    this: &Option<super::Either<L, R>>,
    serializer: S,
) -> Result<S::Ok, S::Error>
where
    S: Serializer,
    L: Serialize,
    R: Serialize,
{
    let untagged = match this {
        Some(super::Either::Left(left)) => Some(Either::Left(left)),
        Some(super::Either::Right(right)) => Some(Either::Right(right)),
        None => None,
    };
    untagged.serialize(serializer)
}

pub fn deserialize<'de, L, R, D>(deserializer: D) -> Result<Option<super::Either<L, R>>, D::Error>
where
    D: Deserializer<'de>,
    L: Deserialize<'de>,
    R: Deserialize<'de>,
{
    match Option::deserialize(deserializer) {
        Ok(Some(Either::Left(left))) => Ok(Some(super::Either::Left(left))),
        Ok(Some(Either::Right(right))) => Ok(Some(super::Either::Right(right))),
        Ok(None) => Ok(None),
        Err(error) => Err(error),
    }
}
