% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolve.factor}
\alias{resolve.factor}
\title{Resolve Guide for Factor}
\usage{
\method{resolve}{factor}(x, ...)
}
\arguments{
\item{x}{factor}

\item{...}{passed to \code{\link{explicit_guide}}, \code{\link{classified}}, and \code{\link{make_title}}}
}
\value{
classified
}
\description{
Resolves implicit usage of default key 'guide' to
explicit usage for factor.
Calls \code{\link{explicit_guide}}
followed by \code{\link{classified}}.
If option \code{yamlet_with_title} is not NULL, and if 'units'
present, label and units will be concatenated by default to create
a title attribute (but this is generally unexpected).
}
\details{
If decorating a factor with a guide, it is recommended to 
supply one that resolves to a codelist. An even safer practice
is to convert the factor first to character, so that there are 
no factor levels to disagree with the (somewhat equivalent) codelist.
}
\examples{
library(magrittr)
x <- factor(1:3)
attr(x, 'guide') <- list(a = 1, b = 2, c = 3)
x
resolve(x)
x <- data.frame(bar = x)
x
resolve(x)

}
\seealso{
Other resolve: 
\code{\link{desolve}()},
\code{\link{desolve.classified}()},
\code{\link{desolve.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{desolve.default}()},
\code{\link{desolve.dvec}()},
\code{\link{resolve}()},
\code{\link{resolve.classified}()},
\code{\link{resolve.data.frame}()},
\code{\link{resolve.decorated}()},
\code{\link{resolve.default}()},
\code{\link{resolve.dvec}()}

Other dvec: 
\code{\link{[.dvec}()},
\code{\link{[<-.dvec}()},
\code{\link{[[.dvec}()},
\code{\link{[[<-.dvec}()},
\code{\link{as.data.frame.dvec}()},
\code{\link{as_dvec}()},
\code{\link{as_dvec.character}()},
\code{\link{as_dvec.complex}()},
\code{\link{as_dvec.dvec}()},
\code{\link{as_dvec.integer}()},
\code{\link{as_dvec.logical}()},
\code{\link{as_dvec.numeric}()},
\code{\link{c.dvec}()},
\code{\link{classified.dvec}()},
\code{\link{desolve.dvec}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{format.dvec}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{implicit_guide.factor}()},
\code{\link{length.dvec}()},
\code{\link{print.dvec}()},
\code{\link{resolve.classified}()},
\code{\link{resolve.dvec}()},
\code{\link{unclassified.dvec}()}
}
\concept{dvec}
\concept{resolve}
\keyword{internal}
