% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xkcdrect.R
\name{xkcdrect}
\alias{xkcdrect}
\title{Draw fuzzy rectangles}
\usage{
xkcdrect(
  mapping,
  data,
  ...,
  fillcolour = "grey90",
  bordercolour = "black",
  borderlinewidth = 0.5,
  borderxjitteramount = 0.005,
  borderyjitteramount = 0.005
)
}
\arguments{
\item{mapping}{Mapping between variables and aesthetics generated by \code{\link[ggplot2]{aes}}. See Details.}

\item{data}{Dataset used in this layer.}

\item{...}{Optional arguments.}

\item{fillcolour}{The fill colour of the rectangle.}

\item{bordercolour}{The colour of the fuzzy border lines.}

\item{borderlinewidth}{The thickness of the fuzzy border lines. This is the package's implementation of the \code{linewidth} aesthetic.}

\item{borderxjitteramount}{Horizontal jitter amount for the border.}

\item{borderyjitteramount}{Vertical jitter amount for the border.}
}
\value{
A layer.
}
\description{
It draws fuzzy rectangles.
}
\details{
This function draws fuzzy rectangles.

  It plots rectangles. The following aesthetics are required:
\enumerate{
  \item xmin
  \item ymin
  \item xmax
  \item ymax
}
Additionally, you can use the aesthetics of \code{\link[ggplot2]{geom_path}} and \code{\link[ggplot2]{geom_rect}}.
}
\examples{
\dontrun{
volunteers <- data.frame(year = c(2007:2011),
                         number = c(56470, 56998, 59686, 61783, 64251))

xrange <- range(volunteers$year)
yrange <- range(volunteers$number)

p <- ggplot() + 
     xkcdrect(aes(xmin = year - 0.2, 
                  xmax = year + 0.2,
                  ymin = number - 500,
                  ymax = number + 500),
              data = volunteers, 
              fillcolour = "pink",
              borderlinewidth = 1.2) +
     geom_point(aes(x = year, y = number), data = volunteers) +
     xkcdaxis(xrange, yrange) +
     theme_xkcd()
p
}
}
\seealso{
\code{\link[ggplot2]{aes}}, \code{\link[ggplot2]{geom_path}}
}
\keyword{manip}
