% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ws_tdiff_univariate.r
\name{ws_tdiff_univariate}
\alias{ws_tdiff_univariate}
\title{Welch-Satterthwaite Approximation for Univariate t-Differences}
\usage{
ws_tdiff_univariate(mu1, sigma1, nu1, mu2, sigma2, nu2)
}
\arguments{
\item{mu1}{Location parameter of first distribution}

\item{sigma1}{Scale parameter of first distribution (must be > 0)}

\item{nu1}{Degrees of freedom of first distribution (must be > 4)}

\item{mu2}{Location parameter of second distribution}

\item{sigma2}{Scale parameter of second distribution (must be > 0)}

\item{nu2}{Degrees of freedom of second distribution (must be > 4)}
}
\value{
An S3 object of class "ws_tdiff_univariate" containing:
  \item{mu_diff}{Location parameter of difference (mu1 - mu2)}
  \item{sigma_star}{Effective scale parameter (Equation 1 from paper)}
  \item{nu_star}{Effective degrees of freedom (Equation 2 from paper)}
  \item{input_params}{List of input parameters for reference}
  \item{method}{Character string "univariate"}
}
\description{
Approximates the distribution of the difference between two independent
non-standardized t-distributed random variables using the Welch-Satterthwaite
method.
}
\details{
For two independent non-standardized t-distributed random variables:
\itemize{
  \item X1 ~ t(mu1, sigma1^2, nu1)
  \item X2 ~ t(mu2, sigma2^2, nu2)
}

The difference Z = X1 - X2 is approximated as:
Z ~ t(mu1 - mu2, sigma_star^2, nu_star)

where the effective parameters are computed through moment matching:
\itemize{
  \item sigma_star matches the variance of Z
  \item nu_star is derived from fourth moment matching
}

The method requires nu1 > 4 and nu2 > 4 for the existence of fourth moments.
The approximation quality improves as degrees of freedom increase and
approaches exactness as nu -> infinity (normal limit).
}
\examples{
# Example 1: Different scale parameters
result <- ws_tdiff_univariate(
  mu1 = 0, sigma1 = 1, nu1 = 10,
  mu2 = 0, sigma2 = 1.5, nu2 = 15
)
print(result)

# Example 2: Equal parameters (special case)
result_equal <- ws_tdiff_univariate(
  mu1 = 5, sigma1 = 2, nu1 = 20,
  mu2 = 3, sigma2 = 2, nu2 = 20
)
# Should match ws_tdiff_equal_params(5-3, 2, 20)

}
\references{
Yamaguchi, Y., Homma, G., Maruo, K., & Takeda, K.
Welch-Satterthwaite Approximation for Difference of Non-Standardized
t-Distributed Variables. (unpublished).
}
\seealso{
\code{\link{ws_tdiff_equal_params}} for the special case of equal parameters
\code{\link{dtdiff}}, \code{\link{ptdiff}}, \code{\link{qtdiff}}, \code{\link{rtdiff}}
for distribution functions
}
