% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_functions.R
\name{tdiff_distributions}
\alias{tdiff_distributions}
\alias{dtdiff}
\alias{ptdiff}
\alias{qtdiff}
\alias{rtdiff}
\title{Distribution Functions for Approximated t-Difference}
\usage{
dtdiff(x, ws_result)

ptdiff(q, ws_result)

qtdiff(p, ws_result)

rtdiff(n, ws_result)
}
\arguments{
\item{x, q}{Vector of quantiles}

\item{ws_result}{Result from ws_tdiff_univariate()}

\item{p}{Vector of probabilities}

\item{n}{Number of observations}
}
\value{
For \code{dtdiff}: Numeric vector of density values.
For \code{ptdiff}: Numeric vector of cumulative probabilities.
For \code{qtdiff}: Numeric vector of quantiles.
For \code{rtdiff}: Numeric vector of random samples from the approximated
t-difference distribution.
}
\description{
Distribution Functions for Approximated t-Difference
}
\examples{
result <- ws_tdiff_univariate(0, 1, 10, 0, 1.5, 15)
dtdiff(0, result)
ptdiff(0, result)
qtdiff(c(0.025, 0.975), result)
samples <- rtdiff(100, result)
}
