% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyPepFragments.R
\name{identifyPepFragments}
\alias{identifyPepFragments}
\title{Identify terminal and internal protein/peptide-fragments as matches to experimental MS-peaks}
\usage{
identifyPepFragments(
  expMass,
  pep,
  modTy = NULL,
  minFragSize = 6,
  maxFragSize = 75,
  identMeas = "ppm",
  limitIdent = 5,
  internFra = TRUE,
  specModif = NULL,
  massTy = "mono",
  chargeCatchFilter = TRUE,
  corMutShift = NULL,
  nProc = 1,
  parallDefault = TRUE,
  multParam = NULL,
  maxMod = c(p = 3, h = 1, k = 1, o = 1, m = 1, n = 1, u = 1, r = 1, s = 1),
  recalibrate = TRUE,
  filtAmbiguous = FALSE,
  prefFragmPat = NULL,
  sortOutputByMass = FALSE,
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{expMass}{(matrix or data.frame)}

\item{pep}{(character) protein/peptide sequences to be used for fragmentation}

\item{modTy}{(list) defining fixed and variable modifications}

\item{minFragSize}{(integer) min length in AA of peptides to be considered (please see you spectrometers characteristics)}

\item{maxFragSize}{(integer) max length in AA of peptides to be considered (please see you spectrometers characteristics)}

\item{identMeas}{(character) comparison type (used in findCloseMatch(), default ="ppm"), used with limit 'limitIdent'}

\item{limitIdent}{(integer) limit applied to 'identMeas'}

\item{internFra}{(logical) switch from including all internal fragments to terminal fragments only (if F)}

\item{specModif}{(list) optional custom single-site modifications (eg ions bound), will be processed using \code{.singleSpecModif}}

\item{massTy}{(list) list of modifications/fragmentation-type(s) to consider, organipredMae as 'basMod' (any occurance) and 'varMod' (optional aoccurance), 'modPos' (position of modif, integer), 'modMass' (mass to be added), 'modName' (name), 'modFixed' (fixed or variable modif, logical)}

\item{chargeCatchFilter}{(logical) filter (upfront) to consider only peptides containing AAs capable of catching extra charges (K, R, H, defined via \code{.chargeCatchingAA()})}

\item{corMutShift}{(numeric) (numeric) vector of decoy-type possible mass shifts (eg from load("C:/E/projects/MassSpec/fragmIdentif/corMutShift.RData"))}

\item{nProc}{(integer)  number of preocessors to use}

\item{parallDefault}{(logical)  if 'parallDefault'=F no multiprocessor parameters set for BiocParallel}

\item{multParam}{(list)}

\item{maxMod}{(integer) maximum number of residue modifications to be consiered in fragments (values >1 will increase complexity and RAM consumption)}

\item{recalibrate}{(logical) recalibrate based on region with highest density of experim values}

\item{filtAmbiguous}{(logical)}

\item{prefFragmPat}{(matrix) optional custum preferential fragmentation pattern (otherwise \code{.prefFragPattern()} will be used)}

\item{sortOutputByMass}{(logical)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{debug}{(logical) additional messages for debugging}
}
\value{
matrix of idenitfied ions
}
\description{
Function for predicting internal and terminal peptide-fragments and compare them with experimental monoisotopic masses.    
The accuracy of results is given in ppm and a false discovery rate (FDR) for the identification is estimated.
The identifed fragments are also checked for preferential break sites, a score including this and other parameters is given with the results.
}
\examples{
protP <- c(protP="PEPTIDE")
obsMassX <- cbind(a=c(199.1077,296.1605,397.2082,510.2922,625.3192),
  b=c(227.1026,324.1554,425.2031,538.2871,653.3141),
  x=c(729.2937,600.2511,503.1984,402.1507,289.0666),
  y=c(703.3145,574.2719,477.2191,376.1714,263.0874))
rownames(obsMassX) <- c("E","P","T","I","D")      # all 1 & 7 ions not included
modTy1 <- list(basMod=c("b","y"), varMod=c("p","o","q"))
frag1 <- identifyPepFragments(ex=as.numeric(obsMassX), pe=protP, modTy=modTy1, 
  minFragSize=2, chargeCatchFilter=FALSE)
(frag1b <- if(length(unlist(frag1$identif)) >0) modifFragmTabOutput(frag1))
}
\seealso{
\code{\link{makeFragments}}, \code{\link{identifVarModif}}, \code{\link{identifFixedModif}}, \code{\link[wrMisc]{findCloseMatch}}, \code{scoreProteinFragments}
}
