% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_validate_list_sections}
\alias{whapi_validate_list_sections}
\title{Validate \code{list_sections} for Whapi LIST interactive messages}
\usage{
whapi_validate_list_sections(list_sections, verbose = TRUE, trim = TRUE)
}
\arguments{
\item{list_sections}{A list of sections; each section is a named list with
\code{title} (character) and \code{rows} (list of row objects).}

\item{verbose}{Logical (default \code{TRUE}). If \code{TRUE}, prints progress messages
via \pkg{cli}.}

\item{trim}{Logical (default \code{TRUE}). If \code{TRUE}, trims whitespace from
\code{section$title}, \code{row$title}, and \code{row$id} before validating.}
}
\value{
The (possibly trimmed) \code{list_sections} object, invisibly unchanged in shape.
}
\description{
Internal helper that validates the structure of \code{list_sections} used in
Whapi \strong{LIST} messages. Each section must provide a non-empty \code{title}
and a non-empty \code{rows} list. Each row must provide non-empty \code{id} and
\code{title}. The \code{description} field is optional.
}
\details{
Expected structure:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{list_sections <- list(
  list(
    title = "Section title",
    rows = list(
      list(id = "r1", title = "Row title", description = "Optional"),
      ...
    )
  ),
  ...
)
}\if{html}{\out{</div>}}

This function performs \strong{lightweight validation} and (optionally) trims
whitespace from titles and ids to avoid subtle formatting issues.
}
\examples{
sections <- list(
  list(
    title = "Burgers",
    rows = list(
      list(id = "r1", title = "Plain",  description = "No cheese, no sauce"),
      list(id = "r2", title = "Cheese", description = "With melted cheese")
    )
  )
)
whapi_validate_list_sections(sections)

}
\seealso{
Helpers for interactive payloads such as \code{whapi_coerce_buttons_base()},
\code{whapi_coerce_buttons_quick()}, and \code{whapi_coerce_buttons_mixed()}.
}
