% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webhook.R
\name{whapi_parse_updates}
\alias{whapi_parse_updates}
\title{Parse Whapi "messages_updates" array (patch events) into a tibble}
\usage{
whapi_parse_updates(
  lst,
  channel_id = NULL,
  event_type = NULL,
  event_act = NULL
)
}
\arguments{
\item{lst}{A list or single object representing Whapi webhook \code{messages_updates}.
Accepts \code{NULL}, a single update object, or an array.}

\item{channel_id}{Character. Channel identifier (usually passed down from
\code{\link[=whapi_flatten_webhook]{whapi_flatten_webhook()}}).}

\item{event_type}{Character. Event type (\code{"messages_updates"} by default).}

\item{event_act}{Character. Event action (\code{"patch"} by default).}
}
\value{
A tibble with one row per update. Includes contextual columns
(\code{channel_id}, \code{event_type}, \code{event_action}).
}
\description{
Converts the webhook field \code{messages_updates} (patch events) into a
\strong{row-per-update} tibble with a stable schema.
Aligns \strong{before/after} snapshots, the \strong{trigger} (who/what caused the change),
and summarizes the change type(s) in \code{change}.
}
\details{
\itemize{
\item Normalizes input to an array via \code{whapi_as_array(lst, "update")}.
\item Safely extracts from \code{before_update}, \code{after_update}, and \code{trigger}.
\item Uses \code{whapi_scalarize_change()} to turn \code{changes} (vector/list) into a single string.
\item Preserves the same schema as \code{\link[=whapi_parse_messages]{whapi_parse_messages()}} so both outputs can be
combined with \code{dplyr::bind_rows()}.
\item Reply/context columns are included but set to \code{NA}.
\item Time fields: \code{timestamp} (epoch seconds) and \code{timestamp_dt} (POSIXct UTC).
}
}
\keyword{internal}
