% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_normalize_to}
\alias{whapi_normalize_to}
\title{Normalize WhatsApp contact IDs (phone numbers only)}
\usage{
whapi_normalize_to(to)
}
\arguments{
\item{to}{Character. A character vector of WhatsApp numbers in free
text format or JIDs.}
}
\value{
A character vector of normalized IDs (phones -> digits only, JIDs kept as-is).
}
\description{
Cleans and normalizes WhatsApp phone numbers by:
\itemize{
\item Skipping normalization if the entry already contains a JID suffix
(e.g., "@s.whatsapp.net" or "@g.us");
\item Otherwise, removing all non-digit characters (\code{+}, spaces, parentheses, hyphens, etc.);
\item Removing the \strong{ninth digit} (when present) right after the country code
(CC) and area code (SS), in order to standardize to 12 or 13 digits.
}
}
\details{
This function is primarily designed for \strong{Brazilian E.164 numbers} (e.g.,
\verb{+55 (81) 9XXXX-YYYY}).
}
