% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_extract_common_fields}
\alias{whapi_extract_common_fields}
\title{Extract common fields from Whapi API responses}
\usage{
whapi_extract_common_fields(out, fallback_to)
}
\arguments{
\item{out}{A list (parsed JSON) as returned by \code{\link[httr2:resp_body_raw]{httr2::resp_body_json()}}
from a Whapi request.}

\item{fallback_to}{Character(1). A fallback chat id (usually the \code{to} argument
originally passed to the API) used when the response does not contain an
explicit \code{chat_id} or \code{to}.}
}
\value{
A tibble with one row and the following columns:
\itemize{
\item \code{id}: message id;
\item \code{to}: recipient chat id (phone or group);
\item \code{status}: sending status (e.g., "pending", "sent");
\item \code{timestamp}: numeric epoch timestamp (seconds);
\item \code{timestamp_dt}: \code{POSIXct} parsed timestamp in UTC;
\item \code{type}: message type (e.g., "text", "image", "location");
\item \code{sent}: logical/boolean (TRUE if sent flag present);
\item \code{resp}: the full raw response list for inspection.
}
}
\description{
Helper function to standardize parsing of Whapi message responses.
Whapi responses typically return a JSON object with a top-level element
\code{sent} and a nested \code{message} object containing details such as \code{id},
\code{status}, \code{timestamp}, etc.
This function consolidates those fields into a flat tibble, making it easier
to work with message metadata in R.
}
\details{
The function safely looks up fields in multiple possible locations, since
Whapi responses are not always consistent across endpoints:
\itemize{
\item \strong{id}: prefers \code{out$message$id}, then \code{out$id}, then \code{out$message_id};
\item \strong{status}: \code{out$message$status} or \code{out$status};
\item \strong{timestamp}: \code{out$message$timestamp} or \code{out$timestamp};
\item \strong{chat_id}: from \code{out$message$chat_id}, \code{out$message$to}, or \code{fallback_to};
\item \strong{type}: \code{out$message$type} or \code{out$type};
\item \strong{sent}: top-level \code{out$sent} (boolean, TRUE if successfully sent).
}

The timestamp is returned both raw (numeric, seconds since epoch) and as a
parsed \code{POSIXct} column (\code{timestamp_dt}, UTC).
}
\examples{
\dontrun{
# Suppose `resp` is the parsed JSON returned from Whapi:
 out <- list(
   sent = TRUE,
   message = list(
     id = "abc123",
     chat_id = "558199999999@s.whatsapp.net",
     timestamp = 1756426418,
     type = "location",
     status = "pending"
   )
 )

 whapi_extract_common_fields(out, fallback_to = "558199999999")
}
}
\seealso{
Used internally in wrappers like \code{\link[=whapi_send_text]{whapi_send_text()}},
\code{\link[=whapi_send_image]{whapi_send_image()}}, \code{\link[=whapi_send_document]{whapi_send_document()}},
\code{\link[=whapi_send_location]{whapi_send_location()}}.
}
