% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_coerce_buttons_quick}
\alias{whapi_coerce_buttons_quick}
\title{Coerce and validate QUICK REPLY buttons for Whapi}
\usage{
whapi_coerce_buttons_quick(buttons, verbose = TRUE)
}
\arguments{
\item{buttons}{A \code{data.frame}/\code{tibble} (one row per button) or a list of
named lists. \code{title} is required (or via alias), \code{id} will be auto-created
when missing by \code{\link[=whapi_coerce_buttons_base]{whapi_coerce_buttons_base()}}.}

\item{verbose}{Logical (default \code{TRUE}). If \code{TRUE}, prints progress messages
via \pkg{cli}.}
}
\value{
A list-of-lists of buttons, each including at least \code{title}, \code{id},
and \code{type = "quick_reply"}.
}
\description{
Internal helper that prepares \strong{quick reply} buttons for Whapi interactive
messages. It relies on \code{\link[=whapi_coerce_buttons_base]{whapi_coerce_buttons_base()}} to normalize input
(accept \code{data.frame}/\code{list}, map aliases \code{label}/\code{name} -> \code{title},
auto-generate \code{id} via slug + uniqueness) and then:
\itemize{
\item Enforces \code{type = "quick_reply"} for all buttons;
\item Requires the fields \code{title} and \code{id};
\item Ensures the WhatsApp constraint of \strong{1 to 3} buttons.
}
}
\examples{
 tibble::tribble(~title, "YES", "NO") |>
   whapi_coerce_buttons_base() |>
   whapi_coerce_buttons_quick()

}
\seealso{
\code{\link[=whapi_coerce_buttons_base]{whapi_coerce_buttons_base()}} for normalization; other coercers for
mixed buttons (url/call/copy).
}
