% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.R
\name{notes}
\alias{notes}
\title{Assign notes to frequencies}
\usage{
notes(x, method = "spn", moving.average = FALSE, k = 11)
}
\arguments{
\item{x}{Numeric vector of frequencies in Hz.}

\item{method}{Method of specifying musical pitch. (Default: \code{spn}, i.e., Scientific Pitch Notation).}

\item{moving.average}{Logical. Must apply moving average? (Default: \code{FALSE}).}

\item{k}{Integer width of the rolling window used if moving.average is TRUE. (Default: \code{11}).}
}
\value{
A vector containing the notes for equal-tempered scale, A4 = 440 Hz. When `method = 'spn'` the vector is of class 'ordered factor'. When `method = 'octave'` the vector is of class 'factor'.  When `method = 'midi'` the vector is of class 'integer'.
}
\description{
Returns a vector of notes for equal-tempered scale, A4 = 440 Hz.
}
\details{
The symbol '#' is being used to represent a sharp note, the higher
in pitch by one semitone on Scientific Pitch Notation (SPN).
}
\examples{
library(voice)
notes(c(220,440,880))
notes(c(220,440,880), method = 'octave')
notes(c(220,440,880), method = 'midi')
}
\references{
\url{https://gist.github.com/nvictor/7b4ab7070e210bc1306356f037226dd9}
}
\seealso{
\code{notes_freq}
}
