% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_field3d.R
\name{vector_field3d}
\alias{vector_field3d}
\title{3D vector field in a curvilinear prism}
\usage{
vector_field3d(
  F,
  H1,
  H2,
  G1,
  G2,
  a,
  b,
  NX = 8,
  NY = 6,
  NZ = 6,
  plot = TRUE,
  arrows = c("both", "line", "cone", "none"),
  arrow_scale = 0.08,
  normalize_bias = 1,
  normal_color = "black",
  normal_width = 1.5,
  arrow_color = "black",
  arrow_opacity = 0.9,
  arrow_size = 0.35,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white")
)
}
\arguments{
\item{F}{A function \code{function(x, y, z)} returning a numeric vector
of length three, interpreted as \code{c(Fx, Fy, Fz)}.}

\item{H1, H2}{Functions of one variable \code{x} giving the lower and
upper bounds in the \code{y} direction.}

\item{G1, G2}{Functions of two variables \code{x} and \code{y} giving the
lower and upper bounds in the \code{z} direction.}

\item{a, b}{Numeric endpoints of the interval for \code{x}. It is assumed
that \code{b > a}.}

\item{NX, NY, NZ}{Integers greater than or equal to one giving the grid
density in the three parameter directions. Each parameter is sampled
using a regular sequence between zero and one with \code{N + 1} points.}

\item{plot}{Logical; if \code{TRUE}, the vector field is drawn using
\pkg{plotly}.}

\item{arrows}{Character string indicating the arrow mode. Allowed values
are \code{"both"}, \code{"line"}, \code{"cone"} and \code{"none"}.}

\item{arrow_scale}{Global length scale for arrows, expressed as a
fraction of the largest span of the bounding box.}

\item{normalize_bias}{Numeric saturation bias used in the scaling of the
vector norm. Larger values make the arrow lengths saturate earlier.}

\item{normal_color}{Color for the arrow shafts (line segments).}

\item{normal_width}{Numeric width of the arrow shafts.}

\item{arrow_color}{Color for the arrow heads (cones or chevrons).}

\item{arrow_opacity}{Numeric opacity for arrow heads when cones are
available.}

\item{arrow_size}{Relative size of arrow heads with respect to
\code{arrow_scale}.}

\item{scene}{List with 3D scene options for \pkg{plotly}.}

\item{bg}{List with background colors for the figure, typically with
entries \code{paper} and \code{plot}.}
}
\value{
A list with:
\itemize{
\item \code{points}: a data frame with base positions \code{x, y, z}
and the magnitude of the field at each point,
\item \code{segments}: a data frame with columns
\code{x0, y0, z0, x1, y1, z1} describing the arrow shafts,
\item \code{fig}: a \pkg{plotly} object when \code{plot = TRUE},
otherwise \code{NULL}.
}
}
\description{
Displays a three-dimensional vector field inside a solid region whose
bounds in the variables \code{x}, \code{y} and \code{z} are defined by
user-supplied functions. The region is described by an interval for
\code{x}, lower and upper bounds in the \code{y} direction depending on
\code{x}, and lower and upper bounds in the \code{z} direction that may
depend on both \code{x} and \code{y}. The function samples this volume on
a regular grid and draws arrows representing the vector field using
\pkg{plotly}.
}
\details{
The domain is parameterized by three normalized parameters, one for each
direction. For each grid point, the corresponding physical coordinates
in \code{x}, \code{y} and \code{z} are obtained by linear interpolation
between the lower and upper bounds. The vector field is evaluated at
each of these points.

Arrow lengths are scaled using a saturated version of the vector norm.
This avoids extremely long arrows when the magnitude of the field varies
strongly across the region. A bias parameter controls how quickly the
lengths approach saturation: small magnitudes produce short arrows and
large magnitudes are capped so that they remain visible without
dominating the picture.

Depending on the selected mode, the function can:
\itemize{
\item draw only line segments representing the arrow shafts,
\item draw only arrow heads (cones or chevrons),
\item or combine both shafts and heads.
}

The plotted figure can be customized through colors, opacity settings,
line widths and standard \pkg{plotly} scene options. If plotting is
disabled, the function still returns the sampled data for further
processing.
}
\examples{
\dontshow{if (interactive()) \{}
H1 <- function(x) -1 - x
H2 <- function(x)  1 - x^2
G1 <- function(x, y) y
G2 <- function(x, y) y + 1

F <- function(x, y, z) c(-y, x, 1)

vector_field3d(
  F, H1 = H1, H2 = H2, G1 = G1, G2 = G2,
  a = -1, b = 1, NX = 8, NY = 6, NZ = 6,
  plot = TRUE, arrows = "both",
  arrow_scale = 0.08, normalize_bias = 1,
  normal_color = "rgba(0,0,0,0.6)", normal_width = 2,
  arrow_color  = "#1d3557", arrow_opacity = 0.95, arrow_size = 0.35
)
\dontshow{\}}

}
