% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate_double_polar.R
\name{integrate_double_polar}
\alias{integrate_double_polar}
\title{Numerical Double Integration in Polar Coordinates}
\usage{
integrate_double_polar(
  f,
  theta_min,
  theta_max,
  r_limit1,
  r_limit2,
  n_theta = 100,
  n_r = 100,
  plot_domain = TRUE
)
}
\arguments{
\item{f}{A function R of two variables, \code{f(x, y)}, returning a numeric value (the original integrand).}

\item{theta_min}{The constant lower limit for the outer integral (alpha).}

\item{theta_max}{The constant upper limit for the outer integral (beta).}

\item{r_limit1}{A function R of one variable defining the inner integral's lower limit (r = g1(theta)).}

\item{r_limit2}{A function R of one variable defining the inner integral's upper limit (r = g2(theta)).}

\item{n_theta}{Number of subintervals for the outer integration (theta). Must be even. Default is 100.}

\item{n_r}{Number of subintervals for the inner integration (r). Must be even. Default is 100.}

\item{plot_domain}{Logical. If TRUE, generates a ggplot2 plot of the integration domain in the Cartesian plane. Default is TRUE.}
}
\value{
A list containing:
\itemize{
\item \code{integral_value}: The calculated approximation of the integral.
\item \code{domain_plot}: The ggplot2 object representing the domain (if plot_domain = TRUE).
}
}
\description{
Calculates the definite double integral of a function f(x, y) over a
polar region R, defined by constant limits for theta and functional limits
for the radius r, R: \eqn{g1(theta) <= r <= g2(theta)}, \eqn{alpha <= theta <= beta}.
The integration order used is r dr dtheta.
Uses the Composite Simpson's Rule for numerical approximation.
}
