varoc=function(y,x,tmd.range=NULL,legend="right",lwd=3,digits=2){

  fit=tmd(y=y,x=x,pval="no")

  main="VAROC"
  ylab="True positive fraction"
  xlab="False positive fraction"
  cex.main=1
  cex.axis=1
  cex.lab=1
  cex.legend=1

  if(is.null(tmd.range)){
    tmd.min=tmd.max=NULL
  }else{
    tmd.min=tmd.range[1]
    tmd.max=tmd.range[2]
  }

  #1.data
  tmd=fit$tmd
  tpf=fit$tpf
  fpf=fit$fpf
  M=length(tmd)

  auc=fit$auc
  itmd=fit$itmd

  tmd.title="TMD"
  itmd.title="ITMD="

  #2. tmd range
  tmd.min0=min(tmd,na.rm=TRUE)
  tmd.max0=max(tmd,na.rm=TRUE)

  if(is.null(tmd.min)){
    tmd.min=tmd.min0
  }else{
    tmd.min=min(tmd.min,tmd.min0)
  }
  if(is.null(tmd.max)){
    tmd.max=tmd.max0
  }else{
    tmd.max=max(tmd.max,tmd.max0)
  }

  #3.plot
  #3.1. range
  tmd.order=round((tmd-tmd.min)/(tmd.max-tmd.min)*M,0) #kind of normalization, match TMD to color
  tmd.order[tmd.order==0]=1

  col0=grDevices::colorRampPalette(rainbow(7))(M)
  col1=col0[tmd.order] #line colors

  plot(NA,col=col1,type='p',pch=19,
       ylab=ylab,xlab=xlab,
       main=main,cex.main=cex.main,
       cex.axis=cex.axis,cex.lab=cex.lab,lwd=lwd,xlim=c(0,1),ylim=c(0,1))
  graphics::abline(a=0,b=1,col="darkgray",lwd=1)
  for(m in 2:M)
    graphics::lines(c(tpf[m],tpf[m-1])~c(fpf[m],fpf[m-1]),col=col1[m],type='S',lwd=lwd)
  #for(m in 1:M)
  #  graphics::points(tpf[m]~fpf[m],col=col1[m],cex=0.5,pch=19)

  #3.2. tmd legend
  delta=(tmd.max-tmd.min)/4
  tmd.cut=round(c(tmd.min,tmd.min+delta,tmd.min+2*delta,tmd.min+3*delta,tmd.max),digits)
  tmd.cut=format(tmd.cut)

  rt=0.05 #move to the right because of anti diagnoal line (rt=0 is no moving)
  text(0.5+rt,0.15,tmd.title,cex=cex.legend)

  corrplot::colorlegend(
    colbar=col0,
    labels=tmd.cut,
    at = c(0,0.25,0.50,0.75,1),
    xlim = c(0.05, 0.90)+rt, ylim = c(0, 0.1),
    vertical = FALSE, cex=cex.legend)

  if(legend%in%c("bottomleft", "topleft", "topright", "bottomright", "left", "right", "top", "bottom", "center")){
    AUC.text=paste0("AUC=",format(round(auc,2),nsmall=2))
    ITMD.text=paste0(itmd.title,format(round(itmd,2),nsmall=2))

    graphics::legend(legend,paste0(AUC.text,"\n",ITMD.text),adj=0,cex=cex.legend,bty='n')
  }

  return(fit)
}
