% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{closure_plot_bar}
\alias{closure_plot_bar}
\title{Visualize CLOSURE data in a histogram}
\usage{
closure_plot_bar(
  data,
  frequency = c("absolute-percent", "absolute", "relative", "percent"),
  samples = c("mean", "all"),
  bar_alpha = 0.75,
  bar_color = "#5D3FD3",
  show_text = TRUE,
  text_color = bar_color,
  text_size = 12,
  text_offset = 0.05,
  mark_thousand = ",",
  mark_decimal = "."
)
}
\arguments{
\item{data}{List returned by \code{\link[=closure_generate]{closure_generate()}}.}

\item{frequency}{String (length 1). What should the bars display? The
default, \code{"absolute-percent"}, displays the count of each scale value and
its percentage of all values. Other options are \code{"absolute"}, \code{"relative"},
and \code{"percent"}.}

\item{samples}{String (length 1). How to aggregate the samples? Either take
the average sample (\code{"mean"}, the default) or the sum of all samples
(\code{"all"}). This only matters if absolute frequencies are shown.}

\item{bar_alpha}{Numeric (length 1). Opacity of the bars. Default is \code{0.75}.}

\item{bar_color}{String (length 1). Color of the bars. Default is
\code{"#5D3FD3"}, a purple color.}

\item{show_text}{Logical (length 1). Should the bars be labeled with the
corresponding frequencies? Default is \code{TRUE}.}

\item{text_color}{String (length 1). Color of the frequency labels. By
default, the same as \code{bar_color}.}

\item{text_size}{Numeric. Base font size in pt. Default is \code{12}.}

\item{text_offset}{Numeric (length 1). Distance between the text labels and
the bars. Default is \code{0.05}.}

\item{mark_thousand, mark_decimal}{Strings (length 1 each). Delimiters between
groups of digits in text labels. Defaults are \code{","} for \code{mark_thousand}
(e.g., \code{"20,000"}) and \code{"."} for \code{mark_decimal} (e.g., \code{"0.15"}).}
}
\value{
A ggplot object.
}
\description{
Call \code{closure_plot_bar()} to get a barplot of CLOSURE results.

For each scale value, the bars show how often this value appears in the
full list of possible raw data samples found by the CLOSURE algorithm.
}
\examples{
# Create CLOSURE data first:
data <- closure_generate(
  mean = "3.5",
  sd = "2",
  n = 52,
  scale_min = 1,
  scale_max = 5
)

# Visualize:
closure_plot_bar(data)
}
\seealso{
\code{\link[=closure_plot_ecdf]{closure_plot_ecdf()}}, an alternative visualization.
}
