% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ustats_outlier.R
\name{ustats_outlier}
\alias{ustats_outlier}
\title{Outlier detection using multiple statistical tests}
\usage{
ustats_outlier(dt, check_col = "ppm", verbose = FALSE, ...)
}
\arguments{
\item{dt}{A \code{data.table} or \code{data.frame}.}

\item{check_col}{A character string naming the column to test for outliers.}

\item{verbose}{Logical; print summary statistics when TRUE.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A \code{data.table} containing new columns: \code{out_score}, \code{out_box},
\code{out_quantile}, and \code{out_hampel}.
}
\description{
This function computes an \code{out_score} for each value in a selected column.
The score increases when a value is flagged as an outlier by one or more tests:
IQR test, quantile cutoffs, and Hampel filter.
}
\examples{
ustats_outlier(mf_data_demo, check_col = "ppm")

}
\keyword{misc}
