% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_ume_results.R
\name{export_ume_results}
\alias{export_ume_results}
\title{Export UME Analysis Results}
\usage{
export_ume_results(
  pl,
  mfd,
  mfd_filt = NULL,
  mfd_filt_tf = NULL,
  mfd_filt_tf_pivot = NULL,
  ds_tf = NULL,
  outdir = NULL,
  prefix = "ume",
  figures = FALSE,
  fig_width = 8,
  fig_height = 6,
  fig_device = c("png", "pdf"),
  zip = TRUE,
  metadata = list(),
  env = parent.frame()
)
}
\arguments{
\item{pl}{data.table containing peak data. Mandatory columns include neutral
molecular mass (\code{mass}), peak magnitude (\code{i_magnitude}), and a peak
identifier (\code{peak_id}).}

\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{mfd_filt}{\code{data.table} or coercible object.
Filtered version of the molecular formula dataset (optional).}

\item{mfd_filt_tf}{\code{data.table} or coercible object.
Transformed filtered MFD used in downstream calculations (optional).}

\item{mfd_filt_tf_pivot}{\code{data.table} or coercible object.
Pivoted / wide-format intensity matrix derived from \code{mfd_filt_tf} (optional).}

\item{ds_tf}{\code{data.table} or coercible object.
Transformed diagnostic statistics (optional).}

\item{outdir}{Character.
Output directory in which all export files are stored.
The directory is created if it does not exist.
\strong{Must be provided explicitly}; no default is used to comply with CRAN
policies on writing to the user's filespace.
For temporary exports, use e.g. \code{outdir = file.path(tempdir(), "ume_export")}.}

\item{prefix}{Character.
Prefix for all exported file names (e.g., \code{"SRFA_001"}).
Default: \code{"ume"}.}

\item{figures}{Controls figure export:
\itemize{
\item \code{FALSE} – no figures are exported
\item \code{TRUE} – export all plot-like objects found in \code{env}
\item character vector – export only the listed object names
}

Recognized plot types are:
\strong{ggplot}, \strong{plotly}, and \strong{recordedplot} (base R).}

\item{fig_width, fig_height}{Numeric.
Dimensions of exported figures in inches.
Default: \code{8} × \code{6}.}

\item{fig_device}{Character.
File format for figure export.
One of \code{"png"} (default) or \code{"pdf"}.}

\item{zip}{Logical.
If \code{TRUE} (default), the exported directory is compressed into a \code{.zip} file
in the same parent directory as \code{outdir}.}

\item{metadata}{Named list.
Additional metadata to write into \code{metadata.R}
(e.g., analysis settings, instrument parameters, user comments).
Default: empty list.}

\item{env}{Environment.
Environment from which figure objects should be collected.
Default: \code{parent.frame()}.}
}
\value{
Invisibly returns:
\itemize{
\item the \strong{path to the ZIP file} (if \code{zip = TRUE}), or
\item the \strong{path to the output directory} (if \code{zip = FALSE}).
}
}
\description{
Exports UME analysis results to a structured output folder.
The function writes the following objects to CSV (if provided):
\itemize{
\item \code{pl} – peaklist
\item \code{mfd} – full molecular formula dataset
\item \code{mfd_filt} – filtered MFD
\item \code{mfd_filt_tf} – transformed filtered MFD
\item \code{mfd_filt_tf_pivot} – pivoted intensity matrix
\item \code{ds_tf} – transformed diagnostics / statistics
}

Optionally, the function can export plot objects, create a ZIP archive
of all exported files, and write a metadata file (\code{metadata.R})
containing a reproducibility snapshot that can be used later in
\code{load_ume_results()}.
}
\details{
Export UME Analysis Results
}
\keyword{internal}
