% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{.msg}
\alias{.msg}
\title{Conditional message output for verbose functions}
\usage{
.msg(...)
}
\arguments{
\item{...}{Character strings passed to \code{sprintf()} for formatted output.}
}
\description{
Helper function for internal use to print formatted messages
when \code{verbose = TRUE}. It uses \code{sprintf()} for clean formatting.
}
\details{
This function standardizes how verbose messages are displayed across
package functions. It automatically checks if a variable \code{verbose}
exists in the calling environment and is \code{TRUE}.

Use it inside functions like this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{n <- 5
verbose <- TRUE
.msg("Processing \%d samples...", n)
}\if{html}{\out{</div>}}

If \code{verbose} is not defined or FALSE, no output is shown.
}
\keyword{internal}
