% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals,ubmsFit-method}
\alias{residuals,ubmsFit-method}
\title{Extract Model Residuals}
\usage{
\S4method{residuals}{ubmsFit}(object, submodel, draws = NULL, ...)
}
\arguments{
\item{object}{A fitted model of class \code{ubmsFit}}

\item{submodel}{Submodel to get residuals for, for example \code{"det"}}

\item{draws}{An integer indicating the number of draws to return. The
default and maximum number of draws is the size of the posterior sample.}

\item{...}{Currently ignored}
}
\value{
A matrix of residual values with dimension \code{draws} by
  observations. Note that calculation of residuals
  for the detection submodel is conditional on \eqn{z > 0}, so residuals
  for an observation in a posterior draw where \eqn{z = 0} are assigned
  value \code{NA} (Wright et al. 2019).
}
\description{
Extract residuals for a given submodel from a \code{ubmsFit} object.
Residuals are calculated separately for each submodel
using the posterior predictive distribution of the latent state z,
following Wright et al. (2019).
}
\references{
Wright, W. J., Irvine, K. M., & Higgs, M. D. (2019). Identifying
  occupancy model inadequacies: can residuals separately assess detection
  and presence? Ecology, 100(6), e02703.
}
