% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{gen_dgp_2periods}
\alias{gen_dgp_2periods}
\title{Function that generates panel data with single treatment date assignment and two time periods.}
\usage{
gen_dgp_2periods(size, dgp_type)
}
\arguments{
\item{size}{Integer. Number of units.}

\item{dgp_type}{Integer in \{1,2,3,4\}.
1 = both nuisance functions correct;
2 = only the outcome model correct;
3 = only the propensity score correct;
4 = both nuisance functions incorrect.}
}
\value{
A list with the following elements:
\describe{
\item{data}{A \code{data.table} in long format with columns:
\itemize{
\item \code{id}: unit identifier
\item \code{state}: state variable
\item \code{time}: time variable
\item \code{partition}: partition assignment
\item \code{x1}, \code{x2}, \code{x3}, \code{x4}: covariates
\item \code{y}: outcome variable
\item \code{cluster}: cluster ID (no within-cluster correlation)
}
}
\item{att}{True average treatment effect on the treated (ATT), set to 0.}
\item{att.unf}{Oracle ATT computed under the unfeasible specification.}
\item{eff}{Theoretical efficiency bound for the estimator.}
}
}
\description{
Generate panel data with a single treatment date and two periods
}
