% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology_functions.R
\name{complete_topology}
\alias{complete_topology}
\title{Create a complete topology from data points with neighborhood structure}
\usage{
complete_topology(datos)
}
\arguments{
\item{datos}{Numeric vector containing the data points to analyze}
}
\value{
A \code{list} with four components:
\describe{
\item{R}{List. The equivalence relation defined on the data, where each
element represents a relationship between vertices based on their degrees
and values.}
\item{subbase}{List. The neighborhoods of each vertex, where each element
contains the indices of neighboring vertices in the graph.}
\item{base}{List. The base generated from intersections of neighborhoods,
including the empty set, full set, and all non-empty intersections.}
\item{topology}{List. The complete topology generated by taking unions of
base elements, satisfying the axioms of topological spaces.}
}
}
\description{
Create a complete topology from data points with neighborhood structure
}
\examples{
data <- c(1, 2, 3, 4, 5)
result <- complete_topology(data)
}
