% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_tipse.R
\name{summary.tipse}
\alias{summary.tipse}
\title{Summarize Tipping Point Results (ARD Format)}
\usage{
\method{summary}{tipse}(object, ...)
}
\arguments{
\item{object}{A \code{tipse} object returned by \link{tipping_point_model_free} or
\link{tipping_point_model_based}.}

\item{...}{Additional arguments not used.}
}
\value{
A data frame summarizing:
\itemize{
\item \code{HR} - hazard ratio at that tipping point
\item \code{CONFINT} - 95\% CI at tipping point
\item \code{METHOD} - sampling type used
\item \code{ARMIMP} - arm imputed
\item \code{TIPPT} - parameter where upper CL first crosses 1
\item \code{TIPUNIT} - parameter meaning
\item \code{DESC} - textual interpretation
}
}
\description{
Creates a concise, analysis-results dataset (ARD) from a tipping point
analysis. Identifies the tipping point parameter where the upper CL of the hazard ratio crosses 1
and summarizes key metrics.
}
\examples{
cox1 <- survival::coxph(Surv(AVAL, EVENT) ~ TRT01P, data = codebreak200)
result <- tipping_point_model_based(
  dat = codebreak200,
  reason = "Early dropout",
  impute = "docetaxel",
  imputation_model = "weibull",
  J = 10,
  tipping_range = seq(0.1, 1, by = 0.05),
  cox_fit = cox1,
  verbose = TRUE,
  seed = 12345
)
summary(result)
}
