% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_clean.R
\name{validate_wq}
\alias{validate_wq}
\title{Validate presence of required columns}
\usage{
validate_wq(
  df,
  required = c("ph", "turbidez", "od", "dbo", "nt_total", "p_total", "tds",
    "temperatura", "coliformes"),
  nd_policy = c("ld2", "ld", "zero", "na")
)
}
\arguments{
\item{df}{Input data.frame/tibble to validate.}

\item{required}{Character vector of required column names to check for.}

\item{nd_policy}{Policy for censored values (ND/<LD/<LOQ) when required
columns are not numeric. One of:
\itemize{
\item "ld2" (default): use half the detection limit
\item "ld"           : use the detection limit
\item "zero"         : replace with 0
\item "na"           : replace with NA
}}
}
\value{
The input \code{df} if valid; otherwise, an error is thrown.
}
\description{
Ensures a minimal set of columns exists in the dataset; otherwise throws an
error listing the missing names.
}
\examples{
df_ex <- data.frame(
  ph = 7, turbidez = 2, od = 7, dbo = 3,
  nt_total = 0.8, p_total = 0.05, tds = 150,
  temperatura = 24, coliformes = 200
)
validate_wq(df_ex)

}
\seealso{
\code{\link[=read_wq]{read_wq()}}, \code{\link[=conama_check]{conama_check()}}
}
