% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synth_spec.R
\name{synth_spec_recipes_api}
\alias{synth_spec_recipes_api}
\alias{add_custom_steps}
\alias{update_custom_steps}
\alias{remove_custom_steps}
\title{Add, update, or remove recipe recipes from a \code{synth_spec} object}
\usage{
add_custom_steps(synth_spec, ...)

update_custom_steps(synth_spec, ...)

remove_custom_steps(synth_spec)
}
\arguments{
\item{synth_spec}{A \code{synth_spec} object}

\item{...}{Optional named arguments mapping variables to lists of
\code{recipe::recipe_} function(s) from \code{library(recipes)}.}
}
\value{
A new \code{synth_spec} object.

A new \code{synth_spec} object with added custom steps.

A new \code{synth_spec} object with updated custom steps.

A new \code{synth_spec} object with removed custom steps.
}
\description{
Add, update, or remove recipe recipes from a \code{synth_spec} object
}
\examples{

synth_spec <- synth_spec()

step1 <- function(x) {
  x |> recipes::step_center(recipes::all_predictors(), id = "center")
}

add_custom_steps(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "steps" = step1)
)


synth_spec <- synth_spec()

step1 <- function(x) {
  x |> recipes::step_center(recipes::all_predictors(), id = "center")
}

update_custom_steps(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "steps" = step1)
)


synth_spec <- synth_spec()

step1 <- function(x) {
  x |> recipes::step_center(recipes::all_predictors(), id = "center")
}

synth_spec <- add_custom_steps(
  synth_spec = synth_spec, 
  list("vars" = c("a", "b", "c"), "steps" = step1)
)

remove_custom_steps(synth_spec = synth_spec)

}
