% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{print.constraints}
\alias{print.constraints}
\title{Print the constraints object to the console with formatting}
\usage{
\method{print}{constraints}(x, ...)
}
\arguments{
\item{x}{A \code{constraints} object}

\item{...}{further arguments passed to or from other methods (not currently
used).}
}
\value{
Invisibly returns the input \code{constraints} object.
}
\description{
Print the constraints object to the console with formatting
}
\examples{

rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
)

constraints_df_num <- 
  tibble::tribble(~var, ~min, ~max, ~conditions,
                  "transit_time", 0, 300, "TRUE")

constraints <- constraints(
  schema = rm[["schema"]],
  constraints_df_num = constraints_df_num,
  max_z_num = 0
)

print(constraints)

}
