% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invert.R
\name{invert.step_YeoJohnson}
\alias{invert.step_YeoJohnson}
\title{Invert a Yeo-Johnson transformation}
\usage{
\method{invert}{step_YeoJohnson}(object, predictions, ...)
}
\arguments{
\item{object}{A recipe after fitting a model}

\item{predictions}{A data frame with .pred}

\item{...}{Other arguments}
}
\value{
A tibble with the Yeo_johnson transformation inverted for .pred
}
\description{
Invert a Yeo-Johnson transformation
}
\examples{

data <- tibble::tibble(
  y = rlnorm(n = 1000, meanlog = 0, sdlog = 1),
  x = rnorm(n = 1000)
)

adj <- recipes::recipe(y ~ x, data = data) |>
  recipes::step_YeoJohnson(recipes::all_outcomes()) |>
  recipes::prep()
  
invert(
  object = adj$steps[[1]], 
  predictions = tibble::tibble(.pred = adj[["template"]][["y"]])
)

}
