% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_noise_kde.R
\name{add_noise_kde}
\alias{add_noise_kde}
\title{Add normal noise to predicted values with variances calculated for ntiles
using Gaussian kernel density estimators}
\usage{
add_noise_kde(
  model,
  new_data,
  conf_model_data,
  outcome_var,
  col_schema,
  pred,
  exclusions = NULL,
  n_ntiles = NULL,
  obs_per_ntile = NULL,
  ties_method = "collapse",
  sd_scale = 1
)
}
\arguments{
\item{model}{A \code{model_spec} or a list of \code{model_spec}s from \code{library(parsnip)}}

\item{new_data}{A data frame used to generate predictions}

\item{conf_model_data}{A data frame for estimating the predictive model}

\item{outcome_var}{A string name representing the outcome variable}

\item{col_schema}{A list of column schema specifications for the new variable}

\item{pred}{A vector of values predicted by the model}

\item{exclusions}{Numeric values that should not receive extra noise}

\item{n_ntiles}{The number of ntiles}

\item{obs_per_ntile}{A numeric for the minimum number of observations to be
in an ntile. Cannot be used in conjunction with the \code{n_ntiles} argument.}

\item{ties_method}{The ntiles approach to adding noise requires a one-to-one
mapping from model-generated values to ntiles in the original data. The
methods "collapse", "random", and "exclusions" deal with situations where the
ntiles lack unique bounds. "collapse" collapses ntile breaks to preserve the
one-to-one relationship; "random" adds a small random perturbation to the
derived boundaries; finally, "exclusions" treats ntile tie values as derived
exclusions.}

\item{sd_scale}{float, a positive number to scale the estimated KDE variance.
Defaults to 1.0}
}
\value{
A numeric vector with noise added to each prediction
}
\description{
Add normal noise to predicted values with variances calculated for ntiles
using Gaussian kernel density estimators
}
\examples{

add_noise_kde(
  model = NULL,
  new_data = tibble::tibble(x = 1:100),
  conf_model_data = tibble::tibble(x = 1:100),
  outcome_var = "x",
  col_schema = NULL,
  pred = 1:100,
  n_ntiles = 4
)

}
