% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_noise_disc_gaussian.R
\name{add_noise_disc_gaussian}
\alias{add_noise_disc_gaussian}
\title{Add discrete normal noise with mean 0 to predicted values with constant variance}
\usage{
add_noise_disc_gaussian(
  model,
  new_data,
  conf_model_data,
  outcome_var,
  col_schema,
  pred,
  variance = NULL,
  rho = NULL,
  sensitivity = NULL,
  increment = 1
)
}
\arguments{
\item{model}{A \code{model_spec} or a list of \code{model_spec}s from \code{library(parsnip)}}

\item{new_data}{A data frame used to generate predictions}

\item{conf_model_data}{A data frame for estimating the predictive model}

\item{outcome_var}{A string name representing the outcome variable}

\item{col_schema}{A list of column schema specifications for the new variable}

\item{pred}{A vector of values predicted by the model}

\item{variance}{float, sampling variance for additive noise}

\item{rho}{float, alternative privacy loss budget prescribed by the Gaussian
mechanism under rho-zero-concentrated differential privacy.}

\item{sensitivity}{float, alternative sample sensitivity prescribed by the Gaussian
mechanism under rho-zero-concentrated differential privacy.}

\item{increment}{Numeric indicating space between discrete noise samples,
defaults to 1. Note that this does not impact the noise sampling variance, as
the increment rescales noise distributions specified by sampling variance.}
}
\value{
A numeric vector with noise added to each prediction
}
\description{
Add discrete normal noise with mean 0 to predicted values with constant variance
}
\examples{

add_noise_disc_gaussian(
  model = NULL,
  new_data = NULL,
  conf_model_data = NULL,
  outcome_var = NULL,
  col_schema = NULL,
  pred = 1:100,
  variance = 3
)

}
