% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_by_react.R
\name{answer_by_react}
\alias{answer_by_react}
\title{Set ReAct mode for a prompt}
\usage{
answer_by_react(
  prompt,
  extract_from_finish_brackets = TRUE,
  extraction_lenience = TRUE
)
}
\arguments{
\item{prompt}{A single string or a \code{\link[=tidyprompt]{tidyprompt()}} object}

\item{extract_from_finish_brackets}{A logical indicating whether the final answer
should be extracted from the text inside the "FINISH\link{...}" brackets}

\item{extraction_lenience}{A logical indcating whether the extraction function should be lenient.
If TRUE, the extraction function will attempt to extract the final answer
even if it cannot be extracted from within the brackets, by extracting
everything after the final occurence of 'FINISH' (if present). This may
be useful for smaller LLMs which may not follow the output format
as strictly}
}
\value{
A \code{\link[=tidyprompt]{tidyprompt()}} with an added \code{\link[=prompt_wrap]{prompt_wrap()}} which will ensure
that the LLM follows the ReAct mode in answering the prompt
}
\description{
This function enables ReAct mode for the evaluation of a prompt
or a \code{\link[=tidyprompt]{tidyprompt()}}. In ReAct mode, the large language model (LLM) is asked to think step by step,
each time detailing a thought, action, and observation, to eventually arrive at
a final answer. It is hypothesized that this may increase LLM performance
at solving complex tasks. ReAct mode is inspired by the method described in
Yao et al. (2022).
}
\details{
Please note that ReAct mode may be most useful if in combination
with tools that the LLM can use. See, for example, 'add_tools()' for
enabling R function calling, or, for example, 'answer_as_code()' with
'output_as_tool = TRUE' for enabling R code evaluation as a tool.
}
\examples{
\dontrun{
  "What is 5 + 5?" |>
    answer_by_react() |>
    answer_as_integer() |>
    send_prompt()
  # --- Sending request to LLM provider (llama3.1:8b): ---
  # You are given a user's prompt.
  # To answer the user's prompt, you need to think step by step,
  # take an action if needed, and then return a final answer.
  #
  # ----- START OF USER'S PROMPT -----
  # What is 5 + 5?
  #
  # You must answer with only an integer (use no other characters).
  # ----- END OF USER'S PROMPT -----
  #
  # Use the following structure:
  #   Thought: <describe your thought process>
  #   Action: <if needed, describe the action you take (e.g., look up information)>
  #   Observation: <describe the result or observation from the action>
  # (Repeat Thought -> Action -> Observation as necessary)
  #
  # When you are done, you must type:
  #   FINISH[<put here your final answer to the user's prompt>]
  #
  # Ensure your final answer aligns with your reasoning and observations.
  # --- Receiving response from LLM provider: ---
  # Thought: The problem is asking for the sum of two numbers, 5 and 5.
  #
  # Action: None needed, as this is a simple arithmetic operation that can be performed mentally.
  #
  # Observation: I can easily add these two numbers together in my mind to get the result.
  #
  # Thought: To find the sum, I will simply add the two numbers together: 5 + 5 = ?
  #
  # Action: Perform the addition.
  #
  # Observation: The result of adding 5 and 5 is 10.
  #
  # FINISH[10]
  # [1] 10
}
}
\references{
Yao, S., Wu, Y., Cheung, W., Wang, Z., Narasimhan, K., & Kong, L. (2022).
ReAct: Synergizing Reasoning and Acting in Language Models.
\url{doi:10.48550/arXiv.2210.03629}
}
\seealso{
\code{\link[=answer_using_tools]{answer_using_tools()}} \code{\link[=answer_using_r]{answer_using_r()}}

Other pre_built_prompt_wraps: 
\code{\link{add_image}()},
\code{\link{add_text}()},
\code{\link{answer_as_boolean}()},
\code{\link{answer_as_category}()},
\code{\link{answer_as_integer}()},
\code{\link{answer_as_json}()},
\code{\link{answer_as_list}()},
\code{\link{answer_as_multi_category}()},
\code{\link{answer_as_named_list}()},
\code{\link{answer_as_regex_match}()},
\code{\link{answer_as_text}()},
\code{\link{answer_by_chain_of_thought}()},
\code{\link{answer_using_r}()},
\code{\link{answer_using_sql}()},
\code{\link{answer_using_tools}()},
\code{\link{prompt_wrap}()},
\code{\link{quit_if}()},
\code{\link{set_system_prompt}()}

Other answer_by_prompt_wraps: 
\code{\link{answer_by_chain_of_thought}()}
}
\concept{answer_by_prompt_wraps}
\concept{pre_built_prompt_wraps}
