% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised-clustering.R
\name{tidy_kmeans}
\alias{tidy_kmeans}
\title{Tidy K-Means Clustering}
\usage{
tidy_kmeans(
  data,
  k,
  cols = NULL,
  nstart = 25,
  iter_max = 100,
  algorithm = "Hartigan-Wong"
)
}
\arguments{
\item{data}{A data frame or tibble}

\item{k}{Number of clusters}

\item{cols}{Columns to include (tidy select). If NULL, uses all numeric columns.}

\item{nstart}{Number of random starts (default: 25)}

\item{iter_max}{Maximum number of iterations (default: 100)}

\item{algorithm}{K-means algorithm: "Hartigan-Wong" (default), "Lloyd", "Forgy", "MacQueen"}
}
\value{
A list of class "tidy_kmeans" containing:
\itemize{
\item clusters: tibble with observation IDs and cluster assignments
\item centers: tibble of cluster centers
\item metrics: tibble with clustering quality metrics
\item model: original kmeans object
}
}
\description{
Performs k-means clustering with tidy output
}
\examples{
# Basic k-means
km_result <- tidy_kmeans(iris, k = 3)

}
