% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{min_time_reference}
\alias{min_time_reference}
\title{Minimum time required per query}
\format{
A tibble dataframe
\describe{
\item{method}{Geocoding service name}
\item{min_time}{The minimum number of seconds required per query to comply with usage restrictions}
\item{description}{A description of the usage rate restriction}
}
}
\usage{
min_time_reference
}
\description{
The \link{geo} and \link{reverse_geo} functions use this dataset
to set the maximum query rate for each geocoding service.
This rate is based on the usage restriction policies for
each geocoding service.
}
\details{
Links to the usage policies of each geocoding service are below:
\itemize{
\item \href{https://operations.osmfoundation.org/policies/nominatim/}{Nominatim}
\item \href{https://www.census.gov/programs-surveys/geography/technical-documentation/complete-technical-documentation/census-geocoder.html}{US Census}
\item \href{https://developers.arcgis.com/pricing/}{ArcGIS}
\item \href{https://www.geocod.io/pricing/}{Geocodio}
\item \href{https://locationiq.com/pricing}{Location IQ}
\item \href{https://developers.google.com/maps/documentation/geocoding/usage-and-billing}{Google}
\item \href{https://opencagedata.com/pricing}{OpenCage}
\item \href{https://www.mapbox.com/pricing}{Mapbox}
\item \href{https://www.here.com/get-started/pricing}{HERE}
\item \href{https://developer.tomtom.com/store/maps-api}{TomTom}
\item \href{https://developer.mapquest.com/plans/}{MapQuest}
\item \href{https://learn.microsoft.com/en-us/bingmaps/spatial-data-services/geocode-and-data-source-limits}{Bing}
\item \href{https://www.geoapify.com/term-and-conditions}{Geoapify}
}
}
\seealso{
\link{geo} \link{reverse_geo}
}
\keyword{datasets}
