% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidydp.R
\name{dp_add_noise}
\alias{dp_add_noise}
\title{Add Differentially Private Noise to Data Frame Columns}
\usage{
dp_add_noise(
  data,
  columns,
  epsilon,
  delta = NULL,
  lower = NULL,
  upper = NULL,
  mechanism = NULL,
  .budget = NULL
)
}
\arguments{
\item{data}{A data frame}

\item{columns}{Character vector of column names to add noise to}

\item{epsilon}{Privacy parameter (smaller = more privacy, more noise)}

\item{delta}{Privacy parameter for Gaussian mechanism (default: NULL, uses Laplace)}

\item{lower}{Named numeric vector of lower bounds for each column}

\item{upper}{Named numeric vector of upper bounds for each column}

\item{mechanism}{Either "laplace" or "gaussian" (auto-selected based on delta if NULL)}

\item{.budget}{Optional privacy budget object to track expenditure}
}
\value{
Data frame with noise added to specified columns
}
\description{
Adds calibrated Laplace or Gaussian noise to specified numeric columns in a data frame
to achieve differential privacy. This is the primary function for column-level privacy.
}
\examples{
data <- data.frame(age = c(25, 30, 35, 40), income = c(50000, 60000, 70000, 80000))
private_data <- data \%>\%
  dp_add_noise(
    columns = c("age", "income"),
    epsilon = 0.1,
    lower = c(age = 0, income = 0),
    upper = c(age = 100, income = 200000)
  )
}
