% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kneeid.R
\name{kneeallconds}
\alias{kneeallconds}
\title{Calculate knee for each condition separately}
\usage{
kneeallconds(alldf, expdf, expthres, nbcpu = 1, rounding = 10,
showtime = FALSE, verbose = TRUE)
}
\arguments{
\item{alldf}{A data frame containing all transcript-related information,
including biotype, chromosome, coordinates, transcript, gene, strand,
window, ID and scores retrieved from the bedgraph files.}

\item{expdf}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{expthres}{A numeric value specifying the expression threshold.
Transcripts with average expression values below this threshold will be
filtered out from the returned transcript vector.}

\item{nbcpu}{An integer specifying the number of CPU cores to use for
parallel computation on transcripts. The number of transcripts is equal to
the number of lines provided as input of 'averageandfilterexprs'.
Defaults to \code{1}.}

\item{rounding}{An integer specifying the rounding factor for computing ECDF.
Default is \code{10}.}

\item{showtime}{A logical value indicating if the duration of the function
processing should be indicated before ending. Defaults to \code{FALSE}.}

\item{verbose}{A logical flag indicating whether to print progress messages.
Defaults to \code{TRUE}.}
}
\value{
A data.frame with the columns \code{transcript}, \code{gene}, and
\code{strand window_size}. For each condition 'cond': \code{AUC_cond},
\code{p_AUC_cond}, \code{D_AUC_cond}, \code{MeanValueFull_cond},
\code{adjFDR_p_AUC_cond}, \code{knee_AUC_cond}, and \code{max_diff_Fx_cond}.
}
\description{
This function calculate knees for each condition separately
}
\details{
The kneeallconds function calls successively for each condition:
\itemize{
  \item averageandfilterexprs This function calculates the average expression levels for transcripts from alldf that was obtained with the 'preprocessing' function. It filters out transcripts based on the 'expthres' expression threshold. The function also renames the columns in the output data frame to include mean expression values. It returns a list containing the original alldf with the mean columns added and a character vector of transcripts that meet the filtering criteria.
  \item genesECDF It takes the result of 'averageandfilterexprs' as input and a) filters the main expression table to retain only the expressed transcripts; b) Splits the data by each transcript; c) For each transcript, computes ECDF values for the score columns while respecting the strand orientation ("plus" or "minus"); d) Combines the ECDF results into a final data frame. It returns a list containing two elements: A data frame with ECDF results for each transcript (concatdf) and an integer indicating the number of rows in each transcript table.
  \item meandifference It takes the result of 'genesECDF' as input and calculates the mean values, mean Fx (ECDF) and ECDF differences (Fx) for expression data, across different experimental conditions. It returns a data frame that contains, for each condition: mean values for the "value" and "Fx" columns (e.g., \code{mean_value_ctrl}, \code{mean_Fx_ctrl}) and the differences between the \code{Fx} column and coordinate ratios (e.g., \code{diff_Fx_ctrl}).
  \item Splitting Split the results of 'meandifference' by transcripts and stores the list into bytranslistmean.
  \item allauc It uses the previously computed variable 'bytranslistmean' and it computes the Area Under Curve (AUC) and the differences of AUC between two conditions for a list of transcript data. It returns a data frame containing the AUC and dAUC results for each transcript, along with associated statistical information.
  \item kneeid It uses the previously computed variable 'bytranslistmean' and identifies the knee point (i.e., point of maximum change) and the maximum difference in the empirical cumulative distribution function (ECDF) for each transcript, across different experimental conditions. It returns a data frame where each row corresponds to a transcript and contains the coordinates of the knee point and the maximum ECDF difference for each condition.
}
}
\examples{
exptabpath <- system.file("extdata", "exptab.csv", package="tepr")
alldfpath <- system.file("extdata", "cugusi_6.tsv", package="tepr")
expdf <- read.csv(exptabpath)
alldf <- read.delim(alldfpath, header = FALSE)
expthres <- 0.1
kneedf <- kneeallconds(alldf, expdf, expthres, verbose = FALSE)

}
\seealso{
[averageandfilterexprs()], [genesECDF()], [meandifference()],
[kneeid()]
}
