% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_nested_tabs.R
\name{.call_once_when}
\alias{.call_once_when}
\title{Calls expression when condition is met}
\usage{
.call_once_when(
  eventExpr,
  handlerExpr,
  event.env = parent.frame(),
  handler.env = parent.frame(),
  ...
)
}
\arguments{
\item{eventExpr}{A (quoted or unquoted) logical expression that represents the event;
this can be a simple reactive value like input$click, a call to a reactive expression
like dataset(), or even a complex expression inside curly braces.}

\item{handlerExpr}{The expression to call whenever \code{eventExpr} is
invalidated. This should be a side-effect-producing action (the return
value will be ignored). It will be executed within an \code{\link[shiny:isolate]{isolate()}}
scope.}

\item{event.env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{eventExpr} is a quosure and \code{event.quoted} is \code{TRUE},
then \code{event.env} is ignored.}

\item{handler.env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{handlerExpr} is a quosure and \code{handler.quoted} is \code{TRUE},
then \code{handler.env} is ignored.}

\item{...}{additional arguments passed to \code{observeEvent} with the exception of \code{eventExpr} that is not allowed.}
}
\value{
An observer.
}
\description{
Function postpones \code{handlerExpr} to the moment when \code{eventExpr} (condition) returns \code{TRUE},
otherwise nothing happens.
}
\keyword{internal}
