% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choices_labeled.R
\name{variable_choices}
\alias{variable_choices}
\alias{variable_choices.character}
\alias{variable_choices.data.frame}
\title{Variable label extraction and custom selection from data}
\usage{
variable_choices(data, subset = NULL, fill = FALSE, key = NULL)

\method{variable_choices}{character}(data, subset = NULL, fill = FALSE, key = NULL)

\method{variable_choices}{data.frame}(data, subset = NULL, fill = TRUE, key = NULL)
}
\arguments{
\item{data}{(\code{data.frame} or \code{character})
If \code{data.frame}, then data to extract labels from.
If \code{character}, then name of the dataset to extract data from once available.}

\item{subset}{(\code{character} or \code{function})
If \code{character}, then a vector of column names.
If \code{function}, then this function is used to determine the possible columns (e.g. all factor columns).
In this case, the function must take only single argument "data" and return a character vector.

See examples for more details.}

\item{fill}{(\code{logical(1)}) if \code{TRUE}, the function will return variable names
for columns with non-existent labels; otherwise will return \code{NA} for them.}

\item{key}{(\code{character}) vector with names of the variables, which are part of the primary key
of the \code{data} argument.

This is an optional argument, which allows to identify variables associated
with the primary key and display the appropriate icon for them in the
\code{\link[teal.widgets:optionalSelectInput]{teal.widgets::optionalSelectInput()}} widget.}
}
\value{
Named \code{character} vector with additional attributes or \code{delayed_data} object.
}
\description{
Wrapper on \link{choices_labeled} to label variables basing on existing labels in data.
}
\examples{
library(teal.data)
ADRS <- rADRS
variable_choices(ADRS)
variable_choices(ADRS, subset = c("PARAM", "PARAMCD"))
variable_choices(ADRS, subset = c("", "PARAM", "PARAMCD"))
variable_choices(
  ADRS,
  subset = c("", "PARAM", "PARAMCD"),
  key = default_cdisc_join_keys["ADRS", "ADRS"]
)

# delayed version
variable_choices("ADRS", subset = c("USUBJID", "STUDYID"))

# functional subset (with delayed data) - return only factor variables
variable_choices("ADRS", subset = function(data) {
  idx <- vapply(data, is.factor, logical(1))
  names(data)[idx]
})
}
