% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_chords}
\alias{scale_chords}
\title{Diatonic chords}
\usage{
scale_chords(
  root = "c",
  scale = "major",
  type = c("triad", "seventh"),
  collapse = FALSE
)
}
\arguments{
\item{root}{character, root note or starting position of scale.}

\item{scale}{character, a valid named scale, referring to one of the
existing \verb{scale_*} functions.}

\item{type}{character, type of chord, triad or seventh.}

\item{collapse}{logical, collapse result into a single string ready for
phrase construction.}
}
\value{
character
}
\description{
Obtain an ordered sequence of the diatonic chords for a given scale, as
triads or sevenths.
}
\examples{
scale_chords("c", "major")
scale_chords("a", "minor")
scale_chords("a", "harmonic minor")
scale_chords("a", "melodic minor")
scale_chords("a", "jazz minor")
scale_chords("a", "hungarian minor")

scale_chords("c", "major", "seventh", collapse = TRUE)
scale_chords("a", "minor", "seventh", collapse = TRUE)
}
