% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smap.R
\name{smap}
\alias{smap}
\alias{smap,data.frame-method}
\title{optimal parameter search for s-mapping}
\usage{
\S4method{smap}{data.frame}(
  data,
  column,
  target,
  lib = NULL,
  pred = NULL,
  E = 3,
  tau = 1,
  k = E + 1,
  dist.metric = "L1",
  dist.average = TRUE,
  theta = c(0, 1e-04, 3e-04, 0.001, 0.003, 0.01, 0.03, 0.1, 0.3, 0.5, 0.75, 1, 1.5, 2, 3,
    4, 6, 8),
  threads = length(theta)
)
}
\arguments{
\item{data}{observation data.}

\item{column}{name of library variable.}

\item{target}{name of target variable.}

\item{lib}{(optional) libraries indices.}

\item{pred}{(optional) predictions indices.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of time lags.}

\item{k}{(optional) number of nearest neighbors used in prediction.}

\item{dist.metric}{(optional) distance metric (\code{L1}: Manhattan, \code{L2}: Euclidean).}

\item{dist.average}{(optional) whether to average distance.}

\item{theta}{(optional) weighting parameter for distances.}

\item{threads}{(optional) number of threads to use.}
}
\value{
A list
\describe{
\item{\code{xmap}}{forecast performance}
\item{\code{varname}}{name of target variable}
\item{\code{method}}{method of cross mapping}
}
}
\description{
optimal parameter search for s-mapping
}
\examples{
sim = logistic_map(x = 0.4,y = 0.4,step = 45,beta_xy = 0.5,beta_yx = 0)
smap(sim,"x","y",E = 10,k = 7,threads = 1)

}
\references{
Sugihara G. 1994. Nonlinear forecasting for the classification of natural time series. Philosophical Transactions: Physical Sciences and Engineering, 348 (1688):477-495.
}
