% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildReference.R
\name{buildReference}
\alias{buildReference}
\title{Function for building a Symphony reference starting from expression matrix}
\usage{
buildReference(
  exp_ref,
  metadata_ref,
  vars = NULL,
  K = 100,
  verbose = FALSE,
  do_umap = TRUE,
  do_normalize = TRUE,
  vargenes_method = "vst",
  vargenes_groups = NULL,
  topn = 2000,
  tau = 0,
  theta = 2,
  save_uwot_path = NULL,
  d = 20,
  additional_genes = NULL,
  umap_min_dist = 0.1,
  seed = 111
)
}
\arguments{
\item{exp_ref}{Reference gene expression (genes by cells)}

\item{metadata_ref}{Reference cell metadata (cells by attributes)}

\item{vars}{Reference variables to Harmonize over e.g. c('donor', 'technology')}

\item{K}{Number of soft cluster centroids in model}

\item{verbose}{Verbose output}

\item{do_umap}{Perform UMAP visualization on harmonized reference embedding}

\item{do_normalize}{Perform log(CP10K+1) normalization}

\item{vargenes_method}{Variable gene selection method (either 'vst' or 'mvp')}

\item{vargenes_groups}{Name of metadata column specifying groups for variable gene selection. If not NULL, calculate topn variable genes in each group separately, then pool}

\item{topn}{Number of variable genes to subset by}

\item{tau}{Tau parameter for Harmony step}

\item{theta}{Theta parameter(s) for Harmony step}

\item{save_uwot_path}{Absolute path to save the uwot model (used if do_umap is TRUE)}

\item{d}{Number of PC dimensions}

\item{additional_genes}{Any custom genes (e.g. marker genes) to include in addition to variable genes}

\item{umap_min_dist}{umap parameter (see uwot documentation for details)}

\item{seed}{Random seed}
}
\value{
Symphony reference object. Integrated embedding is stored in the $Z_corr slot. Other slots include
cell-level metadata ($meta_data), variable genes means and standard deviations ($vargenes),
loadings from PCA ($loadings), original PCA embedding ($Z_orig), reference compression terms ($cache),
betas from Harmony integration ($betas), cosine normalized soft cluster centroids ($centroids),
centroids in PC space ($centroids_pc), and optional umap coordinates ($umap$embedding).
}
\description{
Function for building a Symphony reference starting from expression matrix
}
