% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tranformed_km.R
\name{plot_transformed_km}
\alias{plot_transformed_km}
\title{Plot to assess suitability of parametric model}
\usage{
plot_transformed_km(fit, mod = 1, add_legend = FALSE, graph = "base", ...)
}
\arguments{
\item{fit}{An object of class survHE.}

\item{mod}{Index or name of a model in fit. Defaults to 1.}

\item{add_legend}{If \code{TRUE}, labels assumptions. Defaults to \code{FALSE}.}

\item{graph}{Type of plot: base or ggplot2.}

\item{\dots}{Further arguments, passed on to plot.}
}
\value{
Diagnostic plot
}
\description{
Perform an exploratory investigation for linearity of
transformed survival models.
}
\details{
For the Weibull, twice taking logs of the survivor function

\deqn{log(-log S(t)) = log \lambda + \gamma log t}

A plot of \eqn{log(-log S(t))} against \eqn{log(t)} would give an approximately
straight line if the Weibull assumption is reasonable.
The plot could also be used to give a rough estimate of the parameters.

Similarly, for the log-logistic distribution

\deqn{logS(t)/(1 - S(t)) = \theta - \kappa log t}

For the log-normal distribution

\deqn{\Phi^{-1} (1 - S(t)) = (log t - \mu) / \sigma}

We can also check the assumption made with using the Cox regression model
of proportional hazards by inspecting the log-cumulative hazard plot.

\deqn{log H_i(t) = \beta x_i + log H_0(t)}

The transformed curves for different values of the explanatory variables
will be parallel if PH holds.
}
\examples{

data(bc)
form <- formula("Surv(recyrs, censrec) ~ group")

# exponential distribution
fit_exp <- fit.models(form, data = bc,
                  distr = "exp", method = "mle")
plot_transformed_km(fit_exp)
plot_transformed_km(fit_exp, graph = "ggplot2")
                 
# weibull distribution
fit_wei <- fit.models(form, data = bc,
                  distr = "weibull", method = "mle")
plot_transformed_km(fit_wei)
plot_transformed_km(fit_wei, graph = "ggplot2")
                 
# loglogistic distribution
fit_llog <- fit.models(form, data = bc,
                  distr = "loglogistic", method = "mle")
plot_transformed_km(fit_llog)
plot_transformed_km(fit_llog, graph = "ggplot2")
                 
# lognormal distribution
fit_lnorm <- fit.models(form, data = bc,
                  distr = "lognormal", method = "mle")
plot_transformed_km(fit_lnorm)
plot_transformed_km(fit_lnorm, graph = "ggplot2")

## for only one group
form <- formula("Surv(recyrs, censrec) ~ 1")

fit_exp <- fit.models(form, data = bc,
                  distr = "exp", method = "mle")
plot_transformed_km(fit_exp)
plot_transformed_km(fit_exp, graph = "ggplot2")

}
\references{
Collett (2015) Modelling Survival Data in Medical Research, CRC Press
}
\author{
William Browne, Nathan Green
}
\keyword{hplot}
\keyword{survival}
