% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylerignore.R
\name{add_stylerignore}
\alias{add_stylerignore}
\title{Adds the stylerignore column}
\usage{
add_stylerignore(pd_flat)
}
\arguments{
\item{pd_flat}{A parse table.}
}
\description{
If a token should be ignored, the column is set to \code{TRUE},
otherwise to \code{FALSE}.
}
\details{
A token is ignored iff one of the two conditions hold:
\itemize{
\item it falls between a start and a stop marker whereas the markers are on
their own line. Which tokens are recognized as markers is controlled with
the R options \code{styler.ignore_start} and \code{styler.ignore_stop}.
\item it is not a comment, but the last token on the line is a marker.
}

See examples in \link{stylerignore}. Note that you should reuse the stylerignore
column to compute switch points or similar and not a plain
\code{pd$text \%in\% option_read("styler.ignore_start")} because that will fail to
give correct switch points in the case stylerignore sequences are invalid.
}
\keyword{internal}
