% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.test.gen2}
\alias{size.test.gen2}
\title{Sample size for a test of 2-group difference for any type of parameter}
\usage{
size.test.gen2(alpha, pow, se, n0, es, R)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{se}{standard error of parameter estimate from prior/pilot study}

\item{n0}{sample size of prior/pilot study}

\item{es}{planning value of parameter difference}

\item{R}{n2/n1 ratio}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size per group required to test a difference in two
population parameters with desired power using a standard error for a
single parameter estimate from a prior or pilot study. This function can be
used with any type of parameter where the standard error of the parameter
estimate is a function of the square root of the sample size (most parameter
estimates have this property). This function also assumes that the sampling
distribution of the parameter estimate is approximately normal in large
samples. Set R = 1 for equal sample sizes.
}
\examples{
size.test.gen2(.05, .85, .175, 30, .5, 1)

# Should return:
# n1  n2
# 66  66
 

}
