% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.equiv.prop.ps}
\alias{size.equiv.prop.ps}
\title{Sample size for a paired-samples proportion equivalence test}
\usage{
size.equiv.prop.ps(alpha, pow, p1, p2, phi, h)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{p1}{planning value of proportion for measurement 1}

\item{p2}{planning value of proportion for measurement 2}

\item{phi}{planning value of phi correlation}

\item{h}{upper limit for range of practical equivalence}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to perform an equivalence test for the
difference in population proportions with desired power in a paired-samples
design. The value of h specifies a range of practical equivalence, -h to h,
for the difference in population proportions. The absolute difference in
the proportion planning values must be less than h.  Equivalence tests often
require a very large sample size. Equivalence tests usually use 2 x alpha
rather than alpha (e.g., use alpha = .10 rather alpha = .05). This function
sets the effect size equal to the difference in proportion planning values.
Set the phi correlation planning value to the smallest absolute value within
a plausible range for a conservatively large sample size.

For more details, see Section 3.13 of Bonett (2021, Volume 3)
}
\examples{
size.equiv.prop.ps(.1, .8, .30, .35, .40, .15)

# Should return:
# Sample size
#         173


}
\references{
\insertRef{Bonett2021}{statpsych}
}
