% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.lc.mean.bs}
\alias{size.ci.lc.mean.bs}
\title{Sample size for a between-subjects mean linear contrast confidence interval}
\usage{
size.ci.lc.mean.bs(alpha, var, w, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{var}{planning value of average within-group variance}

\item{w}{desired confidence interval width}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group (assuming equal sample sizes)
required to estimate a linear contrast of population means with desired
confidence interval precision in a between-subjects design. Set the
variance planning value to the largest value within a plausible range
for a conservatively large sample size.

For more details, see Section 3.24 of Bonett (2021, Volume 1)
}
\examples{
v <- c(.5, .5, -.5, -.5)
size.ci.lc.mean.bs(.05, 8.0, 3.0, v)

# Should return:
# Sample size per group
#                    15
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
