% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.etasqr}
\alias{size.ci.etasqr}
\title{Sample size for an eta-squared confidence interval}
\usage{
size.ci.etasqr(alpha, etasqr, groups, w)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{etasqr}{planning value of eta-squared}

\item{groups}{number of groups}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size required to estimate an eta-squared coefficient
in a one-way ANOVA with desired confidence interval precision. Set the
planning value of eta-squared to about 1/3 for a conservatively large sample
size.

For more details, see Section 3.24 of Bonett (2021, Volume 1)
}
\examples{
size.ci.etasqr(.05, .2, 3, .15)

# Should return:
# Sample size per group 
#                   103
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
